/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.rss;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.module.content.ContentModule;
import com.sun.syndication.feed.module.content.ContentModuleImpl;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.cache.Cache;
import com.zutubi.pulse.cache.CacheManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectGroup;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.renderer.BuildResultRenderer;
import com.zutubi.pulse.search.BuildResultExpressions;
import com.zutubi.pulse.search.Queries;
import com.zutubi.pulse.search.SearchQuery;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import com.zutubi.pulse.xwork.results.JITFeed;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildResultsRssAction
extends ProjectActionSupport {
    private CacheManager cacheManager;
    private BuildResultRenderer buildResultRenderer;
    private MasterConfigurationManager configurationManager;
    private Queries queries;
    private JITFeed feed;
    private long userId = -1L;
    private long groupId = -1L;

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public void setGroupId(long groupId) {
        this.groupId = groupId;
    }

    public JITFeed getFeed() {
        return this.feed;
    }

    public String execute() {
        if (!this.configurationManager.getAppConfig().getRssEnabled().booleanValue()) {
            this.addActionError("rss feed is disabled");
            return "disabled";
        }
        Project project = this.getProject();
        if (project == null) {
            if (this.userId != -1L) {
                User u = this.userManager.getUser(this.userId);
                this.feed = new BuildJITFeed(new UserDashboardTemplate(u));
            } else if (this.groupId != -1L) {
                ProjectGroup g = this.projectManager.getProjectGroup(this.groupId);
                this.feed = new BuildJITFeed(new ProjectGroupTemplate(g));
            } else {
                this.feed = new BuildJITFeed(new AllProjectsResultTemplate());
            }
        } else {
            this.feed = new BuildJITFeed(new ProjectResultTemplate(project));
        }
        return "rss";
    }

    private <X> List<X> asList(X ... objs) {
        LinkedList<X> l = new LinkedList<X>();
        for (X x : objs) {
            l.add(x);
        }
        return l;
    }

    private String renderResult(BuildResult result) {
        StringWriter w = new StringWriter();
        this.buildResultRenderer.render(this.configurationManager.getAppConfig().getBaseUrl(), result, this.getBuildManager().getChangesForBuild(result), "html-email", w);
        return w.toString();
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setBuildResultRenderer(BuildResultRenderer buildResultRenderer) {
        this.buildResultRenderer = buildResultRenderer;
    }

    public void setQueries(Queries queries) {
        this.queries = queries;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SyndEntry> fetch(String key, List<Long> ids, SyndFeedEntryFactory factory) {
        Cache cache = this.cacheManager.getCache("BuildResultsRss");
        LinkedList<CacheEntry> entries = (LinkedList<CacheEntry>)cache.get(key);
        if (entries == null) {
            entries = new LinkedList<CacheEntry>();
            cache.put(key, entries);
        }
        LinkedList<CacheEntry> linkedList = entries;
        synchronized (linkedList) {
            boolean requiresSorting = false;
            for (long id : ids) {
                CacheEntry entry2;
                boolean found = false;
                for (CacheEntry entry2 : entries) {
                    if (entry2.id != id) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                BuildResult result = this.buildManager.getBuildResult(id);
                entry2 = factory.createEntry(result);
                CacheEntry cacheEntry = new CacheEntry(result.getId(), (SyndEntry)entry2);
                entries.add(cacheEntry);
                requiresSorting = true;
            }
            if (requiresSorting) {
                Collections.sort(entries, new Comparator<CacheEntry>(){

                    @Override
                    public int compare(CacheEntry o1, CacheEntry o2) {
                        if (o2.id > o1.id) {
                            return 1;
                        }
                        if (o2.id == o1.id) {
                            return 0;
                        }
                        return -1;
                    }
                });
            }
            while (entries.size() > 10) {
                entries.removeLast();
            }
            LinkedList<SyndEntry> syndEntries = new LinkedList<SyndEntry>();
            for (CacheEntry entry : entries) {
                syndEntries.add(entry.entry);
            }
            return syndEntries;
        }
    }

    private static interface SyndFeedEntryFactory {
        public SyndEntry createEntry(BuildResult var1);
    }

    private class CacheEntry {
        long id;
        SyndEntry entry;

        public CacheEntry(long id, SyndEntry entry) {
            this.id = id;
            this.entry = entry;
        }
    }

    private class BuildJITFeed
    implements JITFeed {
        protected List<Long> results = null;
        protected RssFeedTemplate template;

        public BuildJITFeed(RssFeedTemplate template) {
            SearchQuery<Long> query = template.getQuery();
            this.results = query != null ? query.list() : new LinkedList<Long>();
            this.template = template;
        }

        public boolean hasEntries() {
            return this.results.size() > 0;
        }

        public Date getPublishedDate() {
            BuildResult result = BuildResultsRssAction.this.buildManager.getBuildResult(this.results.get(0));
            return new Date(result.getStamps().getEndTime());
        }

        public Date getUpdatedDate() {
            return null;
        }

        public WireFeed createWireFeed(String format) {
            SyndFeedImpl feed = new SyndFeedImpl();
            feed.setTitle(this.template.getTitle());
            feed.setDescription(this.template.getDescription());
            feed.setLink(this.template.getLink());
            List entries = BuildResultsRssAction.this.fetch(this.template.getUID(), this.results, new SyndFeedEntryFactory(){

                public SyndEntry createEntry(BuildResult result) {
                    SyndEntryImpl entry = new SyndEntryImpl();
                    SyndContentImpl description = new SyndContentImpl();
                    description.setType("text/plain");
                    description.setValue(BuildJITFeed.this.template.getEntryTitle(result));
                    entry.setDescription((SyndContent)description);
                    entry.setTitle(BuildJITFeed.this.template.getEntryTitle(result));
                    ContentModuleImpl content = new ContentModuleImpl();
                    content.setEncodeds(BuildResultsRssAction.this.asList(new String[]{BuildResultsRssAction.this.renderResult(result)}));
                    entry.setModules(BuildResultsRssAction.this.asList(new ContentModule[]{content}));
                    entry.setLink(BuildJITFeed.this.template.getEntryLink(result));
                    entry.setPublishedDate(new Date(result.getStamps().getEndTime()));
                    return entry;
                }
            });
            feed.setEntries(entries);
            return feed.createWireFeed(format);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UserDashboardTemplate
    implements RssFeedTemplate {
        private User user;

        public UserDashboardTemplate(User user) {
            this.user = user;
        }

        @Override
        public SearchQuery<Long> getQuery() {
            Set<Project> projects = BuildResultsRssAction.this.userManager.getUserProjects(this.user, BuildResultsRssAction.this.projectManager);
            if (projects.size() == 0) {
                return null;
            }
            SearchQuery<Long> query = BuildResultsRssAction.this.queries.getIds(BuildResult.class);
            query.add((Criterion)Expression.and((Criterion)BuildResultExpressions.projectIn(projects), (Criterion)BuildResultExpressions.buildResultCompleted()));
            query.setFirstResult(0);
            query.setMaxResults(10);
            query.add(BuildResultExpressions.orderByDescEndDate());
            query.setProjection((Projection)Projections.id());
            return query;
        }

        @Override
        public String getTitle() {
            return "Pulse build results";
        }

        @Override
        public String getDescription() {
            return "This feed contains the latest pulse build results for the dashboard projects.";
        }

        @Override
        public String getLink() {
            return BuildResultsRssAction.this.configurationManager.getAppConfig().getBaseUrl() + "/dashboard.action";
        }

        @Override
        public String getEntryTitle(BuildResult result) {
            return String.format("Project %s build %s %s", result.getProject().getName(), result.getNumber(), result.succeeded() ? "succeeded" : "failed");
        }

        @Override
        public String getEntryLink(BuildResult result) {
            return BuildResultsRssAction.this.configurationManager.getAppConfig().getBaseUrl() + "/viewBuild.action?id=" + result.getId();
        }

        @Override
        public String getUID() {
            return "UserDashboardTemplate." + (this.user != null ? Long.valueOf(this.user.getId()) : "");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProjectResultTemplate
    implements RssFeedTemplate {
        private Project project;

        public ProjectResultTemplate(Project project) {
            this.project = project;
        }

        @Override
        public SearchQuery<Long> getQuery() {
            SearchQuery<Long> query = BuildResultsRssAction.this.queries.getIds(BuildResult.class);
            query.add(BuildResultExpressions.projectEq(this.project));
            query.add(BuildResultExpressions.buildResultCompleted());
            query.setFirstResult(0);
            query.setMaxResults(10);
            query.add(Order.desc((String)"stamps.endTime"));
            query.setProjection((Projection)Projections.id());
            return query;
        }

        @Override
        public String getTitle() {
            return "Pulse build results for " + this.project.getName();
        }

        @Override
        public String getDescription() {
            return "This feed contains the latest pulse build results for the " + this.project.getName() + " project.";
        }

        @Override
        public String getLink() {
            return BuildResultsRssAction.this.configurationManager.getAppConfig().getBaseUrl() + "/currentBuild.action?id=" + this.project.getId();
        }

        @Override
        public String getEntryTitle(BuildResult result) {
            return String.format("Build %s %s", result.getNumber(), result.succeeded() ? "succeeded" : "failed");
        }

        @Override
        public String getEntryLink(BuildResult result) {
            return BuildResultsRssAction.this.configurationManager.getAppConfig().getBaseUrl() + "/viewBuild.action?id=" + result.getId();
        }

        @Override
        public String getUID() {
            return "ProjectResultTemplate." + (this.project != null ? Long.valueOf(this.project.getId()) : "");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProjectGroupTemplate
    implements RssFeedTemplate {
        private ProjectGroup group;

        public ProjectGroupTemplate(ProjectGroup group) {
            this.group = group;
        }

        @Override
        public SearchQuery<Long> getQuery() {
            if (this.group == null) {
                return null;
            }
            List<Project> projects = this.group.getProjects();
            if (projects.size() == 0) {
                return null;
            }
            SearchQuery<Long> query = BuildResultsRssAction.this.queries.getIds(BuildResult.class);
            query.add((Criterion)Expression.and((Criterion)BuildResultExpressions.projectIn(projects), (Criterion)BuildResultExpressions.buildResultCompleted()));
            query.setFirstResult(0);
            query.setMaxResults(10);
            query.add(BuildResultExpressions.orderByDescEndDate());
            query.setProjection((Projection)Projections.id());
            return query;
        }

        @Override
        public String getTitle() {
            return "Pulse build results";
        }

        @Override
        public String getDescription() {
            return "This feed contains the latest pulse build results for project group " + this.group.getName();
        }

        @Override
        public String getLink() {
            return BuildResultsRssAction.this.configurationManager.getAppConfig().getBaseUrl() + "/viewProjects.action";
        }

        @Override
        public String getEntryTitle(BuildResult result) {
            return String.format("Project %s build %s %s", result.getProject().getName(), result.getNumber(), result.succeeded() ? "succeeded" : "failed");
        }

        @Override
        public String getEntryLink(BuildResult result) {
            return BuildResultsRssAction.this.configurationManager.getAppConfig().getBaseUrl() + "/viewBuild.action?id=" + result.getId();
        }

        @Override
        public String getUID() {
            return "ProjectGroupTemplate." + (this.group != null ? Long.valueOf(this.group.getId()) : "");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AllProjectsResultTemplate
    implements RssFeedTemplate {
        private AllProjectsResultTemplate() {
        }

        @Override
        public SearchQuery<Long> getQuery() {
            SearchQuery<Long> query = BuildResultsRssAction.this.queries.getIds(BuildResult.class);
            query.add(BuildResultExpressions.buildResultCompleted());
            query.setFirstResult(0);
            query.setMaxResults(10);
            query.add(BuildResultExpressions.orderByDescEndDate());
            query.setProjection((Projection)Projections.id());
            return query;
        }

        @Override
        public String getTitle() {
            return "Pulse build results";
        }

        @Override
        public String getDescription() {
            return "This feed contains the latest pulse build results.";
        }

        @Override
        public String getLink() {
            return BuildResultsRssAction.this.configurationManager.getAppConfig().getBaseUrl() + "/viewProjects.action";
        }

        @Override
        public String getEntryTitle(BuildResult result) {
            return String.format("Project %s build %s %s", result.getProject().getName(), result.getNumber(), result.succeeded() ? "succeeded" : "failed");
        }

        @Override
        public String getEntryLink(BuildResult result) {
            return BuildResultsRssAction.this.configurationManager.getAppConfig().getBaseUrl() + "/viewBuild.action?id=" + result.getId();
        }

        @Override
        public String getUID() {
            return "AllProjectsResultTemplate";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface RssFeedTemplate {
        public SearchQuery<Long> getQuery();

        public String getTitle();

        public String getDescription();

        public String getLink();

        public String getEntryTitle(BuildResult var1);

        public String getEntryLink(BuildResult var1);

        public String getUID();
    }
}

