/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project.changeviewer;

import com.zutubi.pulse.model.ChangeViewer;
import com.zutubi.pulse.model.CustomChangeViewer;
import com.zutubi.pulse.model.FisheyeChangeViewer;
import com.zutubi.pulse.model.P4WebChangeViewer;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.model.TracChangeViewer;
import com.zutubi.pulse.model.ViewVCChangeViewer;
import com.zutubi.pulse.web.project.changeviewer.ChangeViewerForm;
import com.zutubi.pulse.web.project.changeviewer.CustomChangeViewerForm;
import com.zutubi.pulse.web.project.changeviewer.FisheyeChangeViewerForm;
import com.zutubi.pulse.web.project.changeviewer.P4WebChangeViewerForm;
import com.zutubi.pulse.web.project.changeviewer.TracChangeViewerForm;
import com.zutubi.pulse.web.project.changeviewer.ViewVCChangeViewerForm;
import com.zutubi.pulse.wizard.Wizard;
import com.zutubi.pulse.wizard.WizardTransition;
import com.zutubi.validation.Validateable;
import com.zutubi.validation.ValidationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeViewerWizard
implements Wizard,
Validateable {
    private static final String TYPE_CUSTOM = "custom";
    private static final String TYPE_FISHEYE = "Fisheye";
    private static final String TYPE_P4WEB = "P4Web";
    private static final String TYPE_TRAC = "Trac";
    private static final String TYPE_VIEW_VC = "ViewVC";
    private ProjectManager projectManager;
    private long projectId;
    private SelectType selectState;
    private Object currentState;
    private Map<String, ChangeViewerForm> forms;

    public long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    public Project getProject() {
        return this.projectManager.getProject(this.projectId);
    }

    @Override
    public void initialise() {
        ChangeViewer currentViewer;
        this.forms = new LinkedHashMap<String, ChangeViewerForm>();
        CustomChangeViewerForm custom = new CustomChangeViewerForm();
        this.forms.put(TYPE_CUSTOM, custom);
        FisheyeChangeViewerForm fisheye = new FisheyeChangeViewerForm();
        this.forms.put(TYPE_FISHEYE, fisheye);
        P4WebChangeViewerForm p4 = new P4WebChangeViewerForm();
        this.forms.put(TYPE_P4WEB, p4);
        TracChangeViewerForm trac = new TracChangeViewerForm();
        this.forms.put(TYPE_TRAC, trac);
        ViewVCChangeViewerForm viewVc = new ViewVCChangeViewerForm();
        this.forms.put(TYPE_VIEW_VC, viewVc);
        this.selectState = new SelectType(this.forms.keySet());
        this.currentState = this.selectState;
        Project project = this.projectManager.getProject(this.projectId);
        if (project != null && (currentViewer = project.getChangeViewer()) != null) {
            if (currentViewer instanceof CustomChangeViewer) {
                custom.initialise((CustomChangeViewer)currentViewer);
                this.selectState.setType(TYPE_CUSTOM);
                this.currentState = custom;
            } else if (currentViewer instanceof FisheyeChangeViewer) {
                fisheye.initialise((FisheyeChangeViewer)currentViewer);
                this.selectState.setType(TYPE_FISHEYE);
                this.currentState = fisheye;
            } else if (currentViewer instanceof P4WebChangeViewer) {
                p4.initialise((P4WebChangeViewer)currentViewer);
                this.selectState.setType(TYPE_P4WEB);
                this.currentState = p4;
            } else if (currentViewer instanceof TracChangeViewer) {
                trac.initialise((TracChangeViewer)currentViewer);
                this.selectState.setType(TYPE_TRAC);
                this.currentState = trac;
            } else if (currentViewer instanceof ViewVCChangeViewer) {
                viewVc.initialise((ViewVCChangeViewer)currentViewer);
                this.selectState.setType(TYPE_VIEW_VC);
                this.currentState = viewVc;
            }
        }
    }

    @Override
    public Object getCurrentState() {
        return this.currentState;
    }

    public boolean isInCustomState() {
        return this.currentState == this.forms.get(TYPE_CUSTOM);
    }

    @Override
    public List<WizardTransition> getAvailableActions() {
        if (this.currentState == this.selectState) {
            return Arrays.asList(WizardTransition.NEXT, WizardTransition.CANCEL);
        }
        return Arrays.asList(WizardTransition.PREVIOUS, WizardTransition.FINISH, WizardTransition.CANCEL);
    }

    @Override
    public void doFinish() {
        Project project = this.projectManager.getProject(this.projectId);
        ChangeViewerForm form = this.forms.get(this.selectState.getType());
        project.setChangeViewer(form.constructChangeViewer());
        this.projectManager.save(project);
    }

    @Override
    public Object doNext() {
        if (this.currentState == this.selectState) {
            this.currentState = this.forms.get(this.selectState.getType());
        }
        return this.currentState;
    }

    @Override
    public Object doPrevious() {
        this.currentState = this.selectState;
        return this.currentState;
    }

    @Override
    public void doCancel() {
    }

    @Override
    public Object doRestart() {
        this.currentState = this.selectState;
        return this.currentState;
    }

    public void validate(ValidationContext context) {
        if (this.projectManager.getProject(this.projectId) == null) {
            context.addActionError("Unknown project [" + this.projectId + "]");
        }
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SelectType {
        private String type;
        private List<String> options;

        public SelectType(Collection<String> options) {
            this.options = new ArrayList<String>(options);
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public List<String> getTypeOptions() {
            return this.options;
        }
    }
}

