/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.model.TestSuitePersister;
import com.zutubi.pulse.core.model.TestSuiteResult;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import java.io.File;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewTestSuiteAction
extends ProjectActionSupport {
    private static final Logger LOG = Logger.getLogger(ViewTestSuiteAction.class);
    private long id;
    private long nodeId;
    private String path;
    private BuildResult result;
    private RecipeResultNode node;
    private TestSuiteResult suite;
    private List<String> paths;
    private MasterConfigurationManager configurationManager;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public Project getProject() {
        return this.result.getProject();
    }

    public BuildResult getResult() {
        return this.result;
    }

    public RecipeResultNode getNode() {
        return this.node;
    }

    public TestSuiteResult getSuite() {
        return this.suite;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void validate() {
    }

    public String execute() {
        this.result = this.getBuildManager().getBuildResult(this.id);
        if (this.result == null) {
            this.addActionError("Unknown build [" + this.id + "]");
            return "error";
        }
        this.node = this.result.findResultNode(this.nodeId);
        if (this.node == null || this.node.getResult() == null) {
            this.addActionError("Unknown recipe node [" + this.nodeId + "]");
            return "error";
        }
        File testDir = new File(this.node.getResult().getAbsoluteOutputDir(this.configurationManager.getDataDirectory()), "tests");
        if (this.path != null && this.path.startsWith("/")) {
            this.path = this.path.substring(1);
        }
        if (TextUtils.stringSet((String)this.path)) {
            String[] elements = this.path.split("/");
            this.paths = Arrays.asList(elements);
            testDir = new File(testDir, FileSystemUtils.composeFilename((String[])elements));
        }
        TestSuitePersister persister = new TestSuitePersister();
        try {
            this.suite = persister.read(null, testDir, false, false, -1);
        }
        catch (Exception e) {
            LOG.warning((Throwable)e);
            this.addActionError("Unable to read test suite from directory '" + testDir.getAbsolutePath() + "': " + e.getMessage());
            return "error";
        }
        return "success";
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

