/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.MasterBuildPaths;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ViewRecipeLogAction
extends ProjectActionSupport {
    private long id;
    private long buildId;
    private BuildResult buildResult;
    private RecipeResultNode resultNode;
    private MasterConfigurationManager configurationManager;
    private InputStream inputStream;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getBuildId() {
        return this.buildId;
    }

    public void setBuildId(long buildId) {
        this.buildId = buildId;
    }

    public BuildResult getBuildResult() {
        return this.buildResult;
    }

    public RecipeResultNode getResultNode() {
        return this.resultNode;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String execute() throws Exception {
        this.buildResult = this.getBuildManager().getBuildResult(this.buildId);
        if (this.buildResult == null) {
            this.addActionError("Unknown build [" + this.buildId + "]");
            return "error";
        }
        this.checkPermissions(this.buildResult);
        this.resultNode = this.buildResult.findResultNode(this.id);
        if (this.resultNode == null) {
            this.addActionError("Unknown stage [" + this.id + "]");
            return "error";
        }
        MasterBuildPaths paths = new MasterBuildPaths(this.configurationManager);
        File recipeLog = new File(paths.getRecipeDir(this.buildResult, this.resultNode.getResult().getId()), "recipe.log");
        if (recipeLog.exists()) {
            try {
                this.inputStream = new FileInputStream(recipeLog);
            }
            catch (IOException e) {
                this.addActionError("Unable to open recipe log '" + recipeLog.getAbsolutePath() + "': " + e.getMessage());
                return "error";
            }
        } else {
            this.addActionError("Recipe log '" + recipeLog.getAbsolutePath() + "' does not exist");
            return "error";
        }
        return "success";
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

