/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.model.BuildColumns;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.NamedEntityComparator;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectGroup;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import java.util.Collections;
import java.util.List;
import org.hibernate.SessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewProjectsAction
extends ProjectActionSupport {
    private List<ProjectGroup> groups;
    private List<Project> projects;
    private BuildColumns buildColumns;
    private SessionFactory sessionFactory;

    public List<Project> getProjects() {
        return this.projects;
    }

    public List<ProjectGroup> getGroups() {
        return this.groups;
    }

    public BuildResult getLatestBuild(Project project) {
        List<BuildResult> build = this.getBuildManager().getLatestBuildResultsForProject(project, 1);
        if (build.size() == 0) {
            return null;
        }
        return build.get(0);
    }

    public BuildColumns getColumns() {
        return this.buildColumns;
    }

    public String execute() {
        this.groups = this.projectManager.getAllProjectGroupsCached();
        Collections.sort(this.groups, new NamedEntityComparator());
        this.projects = this.getProjectManager().getAllProjectsCached();
        for (ProjectGroup g : this.groups) {
            this.projects.removeAll(g.getProjects());
        }
        Collections.sort(this.projects, new NamedEntityComparator());
        User user = this.getLoggedInUser();
        this.buildColumns = new BuildColumns(user == null ? User.getDefaultAllProjectsColumns() : user.getAllProjectsColumns(), this.projectManager);
        return "success";
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

