/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.core.model.Changelist;
import com.zutubi.pulse.core.model.ChangelistComparator;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewChangesAction
extends ProjectActionSupport {
    private long id = 0L;
    private long sinceBuild = 0L;
    private long toBuild;
    private Project project;
    private BuildResult previous;
    private BuildResult previousSuccessful;
    private BuildResult previousUnsuccessful;
    private BuildResult sinceResult;
    private BuildResult result;
    private List<Changelist> changelists;

    public void setId(long id) {
        this.id = id;
    }

    public long getSinceBuild() {
        return this.sinceBuild;
    }

    public void setSinceBuild(long sinceBuild) {
        this.sinceBuild = sinceBuild;
    }

    public long getToBuild() {
        return this.toBuild;
    }

    public void setToBuild(long toBuild) {
        this.toBuild = toBuild;
    }

    public BuildResult getSinceResult() {
        return this.sinceResult;
    }

    public BuildResult getResult() {
        return this.result;
    }

    public BuildResult getPrevious() {
        return this.previous;
    }

    public BuildResult getPreviousSuccessful() {
        return this.previousSuccessful;
    }

    public BuildResult getPreviousUnsuccessful() {
        return this.previousUnsuccessful;
    }

    public List<Changelist> getChangelists() {
        return this.changelists;
    }

    public void validate() {
        if (this.id == 0L) {
            this.project = this.getProject();
            if (this.project == null) {
                this.addActionError("Unknown project [" + this.projectId + "]");
                return;
            }
            this.result = this.getBuildManager().getByProjectAndNumber(this.project, this.toBuild);
            if (this.result == null) {
                this.addActionError("No such build [" + this.toBuild + "]");
                return;
            }
        } else {
            this.result = this.getBuildManager().getBuildResult(this.id);
            if (this.result == null) {
                this.addActionError("Unknown build [" + this.id + "]");
                return;
            }
            this.toBuild = this.result.getNumber();
            this.project = this.result.getProject();
            this.projectId = this.project.getId();
        }
        this.previous = this.getPrevious(ResultState.getCompletedStates());
        if (this.sinceBuild == 0L) {
            this.sinceResult = this.previous;
            if (this.previous != null) {
                this.sinceBuild = this.sinceResult.getNumber();
            }
        } else {
            this.sinceResult = this.getBuildManager().getByProjectAndNumber(this.project, this.sinceBuild);
            if (this.sinceResult == null) {
                this.addActionError("No such build [" + this.sinceBuild + "]");
            }
            if (this.sinceBuild >= this.toBuild) {
                this.addActionError("Invalid build range");
            }
            if (this.sinceResult != null && this.result != null && !this.sinceResult.getBuildSpecification().equals(this.result.getBuildSpecification())) {
                this.addActionError("Builds must be of the same specification");
            }
        }
    }

    private BuildResult getPrevious(ResultState[] states) {
        if (this.toBuild == 1L) {
            return null;
        }
        int offset = 0;
        while (true) {
            List<BuildResult> previousResults;
            if ((previousResults = this.getBuildManager().querySpecificationBuilds(this.project, this.result.getSpecName(), states, -1L, this.toBuild - 1L, offset, 1, true, false)).size() > 0) {
                BuildResult buildResult = previousResults.get(0);
                if (!buildResult.isUserRevision() && buildResult.getScmDetails() != null) {
                    return buildResult;
                }
            } else {
                return null;
            }
            ++offset;
        }
    }

    public String execute() {
        this.checkPermissions(this.result);
        this.changelists = new LinkedList<Changelist>();
        if (this.sinceBuild != 0L) {
            List<BuildResult> resultRange = this.getBuildManager().querySpecificationBuilds(this.project, this.result.getSpecName(), ResultState.getCompletedStates(), this.sinceBuild + 1L, this.toBuild - 1L, 0, -1, true, false);
            for (BuildResult r : resultRange) {
                this.changelists.addAll(this.getBuildManager().getChangesForBuild(r));
            }
        }
        this.changelists.addAll(this.getBuildManager().getChangesForBuild(this.result));
        Collections.sort(this.changelists, new ChangelistComparator());
        this.previousSuccessful = this.getPrevious(new ResultState[]{ResultState.SUCCESS});
        this.previousUnsuccessful = this.getPrevious(new ResultState[]{ResultState.ERROR, ResultState.FAILURE});
        return "success";
    }
}

