/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.core.model.Change;
import com.zutubi.pulse.core.model.Changelist;
import com.zutubi.pulse.core.model.FileRevision;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.ChangeViewer;
import com.zutubi.pulse.model.ChangelistUtils;
import com.zutubi.pulse.model.NamedEntity;
import com.zutubi.pulse.model.NamedEntityComparator;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.Scm;
import com.zutubi.pulse.model.persistence.ChangelistDao;
import com.zutubi.pulse.web.ActionSupport;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewChangelistAction
extends ActionSupport {
    private long id;
    private Changelist changelist;
    private ChangelistDao changelistDao;
    private BuildManager buildManager;
    private long projectId;
    private Project project;
    private BuildResult buildResult;
    private long buildId;
    private List<BuildResult> buildResults;
    private boolean changeViewerInitialised;
    private ChangeViewer changeViewer;
    private Scm scm;
    private String fileViewUrl;
    private String fileDownloadUrl;
    private String fileDiffUrl;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    public Project getProject() {
        return this.project;
    }

    public long getBuildId() {
        return this.buildId;
    }

    public void setBuildId(long buildId) {
        this.buildId = buildId;
    }

    public BuildResult getBuildResult() {
        return this.buildResult;
    }

    public Changelist getChangelist() {
        return this.changelist;
    }

    public ChangeViewer getChangeViewer() {
        if (!this.changeViewerInitialised) {
            this.changeViewerInitialised = true;
            Project p = this.project;
            if (this.buildResult != null) {
                p = this.buildResult.getProject();
            }
            if (p != null) {
                this.changeViewer = p.getChangeViewer();
                this.scm = p.getScm();
            } else {
                Iterator i$ = this.changelist.getProjectIds().iterator();
                while (i$.hasNext()) {
                    long id = (Long)i$.next();
                    p = this.projectManager.getProject(id);
                    if (p == null || p.getChangeViewer() == null) continue;
                    this.changeViewer = p.getChangeViewer();
                    this.scm = p.getScm();
                    break;
                }
            }
        }
        return this.changeViewer;
    }

    public boolean haveChangeViewer() {
        return this.getChangeViewer() != null;
    }

    @Override
    public String getChangeUrl() {
        ChangeViewer changeViewer = this.getChangeViewer();
        if (changeViewer != null && changeViewer.hasCapability(this.scm, ChangeViewer.Capability.VIEW_CHANGESET)) {
            return changeViewer.getChangesetURL(this.changelist.getRevision());
        }
        return null;
    }

    public String getFileViewUrl() {
        return this.fileViewUrl;
    }

    public String getFileDownloadUrl() {
        return this.fileDownloadUrl;
    }

    public String getFileDiffUrl() {
        return this.fileDiffUrl;
    }

    public void updateUrls(Change change) {
        this.updateFileViewUrl(change);
        this.updateFileDownloadUrl(change);
        this.updateFileDiffUrl(change);
    }

    public void updateFileViewUrl(Change change) {
        ChangeViewer changeViewer = this.getChangeViewer();
        this.fileViewUrl = changeViewer != null && changeViewer.hasCapability(this.scm, ChangeViewer.Capability.VIEW_FILE) ? changeViewer.getFileViewURL(change.getFilename(), change.getRevision()) : null;
    }

    public void updateFileDownloadUrl(Change change) {
        ChangeViewer changeViewer = this.getChangeViewer();
        this.fileDownloadUrl = changeViewer != null && changeViewer.hasCapability(this.scm, ChangeViewer.Capability.DOWNLOAD_FILE) ? changeViewer.getFileDownloadURL(change.getFilename(), change.getRevision()) : null;
    }

    public void updateFileDiffUrl(Change change) {
        ChangeViewer changeViewer;
        FileRevision previous;
        if (this.diffableAction(change.getAction()) && (previous = change.getRevision().getPrevious()) != null && (changeViewer = this.getChangeViewer()) != null && changeViewer.hasCapability(this.scm, ChangeViewer.Capability.VIEW_FILE_DIFF)) {
            this.fileDiffUrl = changeViewer.getFileDiffURL(change.getFilename(), change.getRevision());
            return;
        }
        this.fileDiffUrl = null;
    }

    private boolean diffableAction(Change.Action action) {
        switch (action) {
            case EDIT: 
            case INTEGRATE: 
            case MERGE: {
                return true;
            }
        }
        return false;
    }

    public void setChangelist(Changelist changelist) {
        this.changelist = changelist;
    }

    public void validate() {
        this.changelist = (Changelist)this.changelistDao.findById(this.id);
        if (this.changelist == null) {
            this.addActionError("Unknown changelist '" + this.id + "'");
        }
    }

    public String execute() {
        if (this.projectId != 0L) {
            this.project = this.projectManager.getProject(this.projectId);
        }
        if (this.buildId != 0L) {
            this.buildResult = this.buildManager.getBuildResult(this.buildId);
        }
        this.buildResults = ChangelistUtils.getBuilds(this.buildManager, this.changelist);
        Collections.sort(this.buildResults, new Comparator<BuildResult>(){

            @Override
            public int compare(BuildResult b1, BuildResult b2) {
                NamedEntityComparator comparator = new NamedEntityComparator();
                int result = comparator.compare((NamedEntity)b1.getProject(), (NamedEntity)b2.getProject());
                if (result == 0) {
                    result = (int)(b1.getNumber() - b2.getNumber());
                }
                return result;
            }
        });
        return "success";
    }

    public void setChangelistDao(ChangelistDao changelistDao) {
        this.changelistDao = changelistDao;
    }

    public void setBuildManager(BuildManager buildManager) {
        this.buildManager = buildManager;
    }

    public List<BuildResult> getBuildResults() {
        return this.buildResults;
    }
}

