/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.core.model.Changelist;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.model.BuildColumns;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectHomeAction
extends ProjectActionSupport {
    private long id;
    private String projectName;
    private Project project;
    private int totalBuilds;
    private int successfulBuilds;
    private int failedBuilds;
    private BuildResult currentBuild;
    private List<Changelist> latestChanges;
    private List<BuildResult> recentBuilds;
    private BuildColumns summaryColumns;
    private BuildColumns recentColumns;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public int getTotalBuilds() {
        return this.totalBuilds;
    }

    public int getSuccessfulBuilds() {
        return this.successfulBuilds;
    }

    public int getFailedBuilds() {
        return this.failedBuilds;
    }

    public int getErrorBuilds() {
        return this.totalBuilds - this.successfulBuilds - this.failedBuilds;
    }

    public int getPercent(int quotient, int divisor) {
        if (divisor > 0) {
            return (int)Math.round((double)quotient * 100.0 / (double)divisor);
        }
        return 0;
    }

    public int getPercentSuccessful() {
        return this.getPercent(this.successfulBuilds, this.totalBuilds);
    }

    public int getPercentSuccessNoErrors() {
        return this.getPercent(this.successfulBuilds, this.totalBuilds - this.getErrorBuilds());
    }

    public int getPercentFailed() {
        return this.getPercent(this.failedBuilds, this.totalBuilds);
    }

    public int getPercentError() {
        return this.getPercent(this.getErrorBuilds(), this.totalBuilds);
    }

    public boolean getProjectNotBuilding() {
        return this.project.getState() == Project.State.PAUSED || this.project.getState() == Project.State.IDLE;
    }

    public BuildResult getCurrentBuild() {
        return this.currentBuild;
    }

    public List<Changelist> getLatestChanges() {
        return this.latestChanges;
    }

    public List<BuildResult> getRecentBuilds() {
        return this.recentBuilds;
    }

    public BuildColumns getSummaryColumns() {
        return this.summaryColumns;
    }

    public BuildColumns getRecentColumns() {
        return this.recentColumns;
    }

    public String execute() {
        this.project = this.id != 0L ? this.getProjectManager().getProject(this.id) : this.getProjectManager().getProject(this.projectName);
        if (this.project != null) {
            BuildManager buildManager = this.getBuildManager();
            this.totalBuilds = buildManager.getBuildCount(this.project, new ResultState[]{ResultState.SUCCESS, ResultState.ERROR, ResultState.FAILURE}, null);
            this.successfulBuilds = buildManager.getBuildCount(this.project, new ResultState[]{ResultState.SUCCESS}, null);
            this.failedBuilds = buildManager.getBuildCount(this.project, new ResultState[]{ResultState.FAILURE}, null);
            this.currentBuild = buildManager.getLatestBuildResult(this.project);
            this.latestChanges = this.getBuildManager().getLatestChangesForProject(this.project, 10);
            this.recentBuilds = buildManager.getLatestBuildResultsForProject(this.project, 11);
            if (!this.recentBuilds.isEmpty()) {
                this.recentBuilds.remove(0);
            }
        } else {
            this.addActionError("Unknown project [" + this.id + "] " + this.projectName);
            return "error";
        }
        User user = this.getLoggedInUser();
        this.summaryColumns = new BuildColumns(user == null ? User.getDefaultProjectColumns() : user.getProjectSummaryColumns(), this.projectManager);
        this.recentColumns = new BuildColumns(user == null ? User.getDefaultProjectColumns() : user.getProjectRecentColumns(), this.projectManager);
        return "success";
    }

    @Override
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
}

