/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.model.ProjectGroup;
import com.zutubi.pulse.web.ActionSupport;
import com.zutubi.pulse.web.project.ProjectFormHelper;
import com.zutubi.pulse.xwork.interceptor.Preparable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectGroupAction
extends ActionSupport
implements Preparable {
    private long groupId;
    private String name;
    private List<Long> projects;
    private ProjectFormHelper helper;
    private ProjectGroup group = new ProjectGroup();

    public long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(long groupId) {
        this.groupId = groupId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Long> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Long> projects) {
        this.projects = projects;
    }

    public Map<Long, String> getAllProjects() {
        return this.getHelper().getAllEntities();
    }

    @Override
    public List<String> getPrepareParameterNames() {
        return Arrays.asList("groupId");
    }

    public void prepare() throws Exception {
        if (this.groupId != 0L) {
            this.group = this.projectManager.getProjectGroup(this.groupId);
            if (this.group == null) {
                this.groupId = 0L;
            }
        }
    }

    public String doInput() throws Exception {
        if (this.group != null) {
            this.name = this.group.getName();
            this.projects = this.getHelper().convertToIds(this.group.getProjects());
        }
        return "input";
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        ProjectGroup g = this.projectManager.getProjectGroup(this.name);
        if (g != null && g.getId() != this.groupId) {
            this.addFieldError("name", this.getText("project.group.duplicate", Arrays.asList(this.name)));
        }
    }

    public String execute() throws Exception {
        this.group.setName(this.name);
        this.getHelper().convertFromIds(this.projects, this.group.getProjects());
        this.projectManager.save(this.group);
        return "success";
    }

    public ProjectFormHelper getHelper() {
        if (this.helper == null) {
            this.helper = new ProjectFormHelper(this.projectManager);
        }
        return this.helper;
    }
}

