/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.web.project.ProjectActionSupport;

public class EditPropertyAction
extends ProjectActionSupport {
    private long specId;
    private long id;
    private String name;
    private String newName;
    private String newValue;
    private boolean newAddToEnvironment = false;
    private boolean newAddToPath = false;
    private boolean newResolveVariables = false;
    private Project project;
    private BuildSpecification spec;
    private ResourceProperty property;

    public Project getProject() {
        return this.project;
    }

    public BuildSpecification getSpec() {
        return this.spec;
    }

    public long getSpecId() {
        return this.specId;
    }

    public void setSpecId(long specId) {
        this.specId = specId;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceProperty getProperty() {
        return this.property;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public boolean getNewAddToEnvironment() {
        return this.newAddToEnvironment;
    }

    public void setNewAddToEnvironment(boolean newAddToEnvironment) {
        this.newAddToEnvironment = newAddToEnvironment;
    }

    public boolean getNewAddToPath() {
        return this.newAddToPath;
    }

    public void setNewAddToPath(boolean newAddToPath) {
        this.newAddToPath = newAddToPath;
    }

    public boolean getNewResolveVariables() {
        return this.newResolveVariables;
    }

    public void setNewResolveVariables(boolean newResolveVariables) {
        this.newResolveVariables = newResolveVariables;
    }

    private void lookupProperty() {
        this.project = this.lookupProject(this.projectId);
        if (this.hasErrors()) {
            return;
        }
        this.spec = this.project.getBuildSpecification(this.specId);
        if (this.spec == null) {
            this.addActionError("Unknown build specification [" + this.specId + "]");
            return;
        }
        this.property = this.spec.getProperty(this.id);
        if (this.property == null) {
            this.addActionError("Unknown property [" + this.id + "]");
        }
    }

    public String doInput() {
        this.lookupProperty();
        if (this.hasErrors()) {
            return "error";
        }
        this.newName = this.property.getName();
        this.newValue = this.property.getValue();
        this.newAddToEnvironment = this.property.getAddToEnvironment();
        this.newAddToPath = this.property.getAddToPath();
        this.newResolveVariables = this.property.getResolveVariables();
        return "input";
    }

    public void validate() {
        this.lookupProperty();
        if (this.hasErrors()) {
            return;
        }
        if (!TextUtils.stringSet((String)this.newName)) {
            this.addFieldError("newName", "name is required");
            return;
        }
        if (!this.property.getName().equals(this.newName) && this.spec.hasProperty(this.newName)) {
            this.addFieldError("newName", "this specification already contains a property with name '" + this.newName + "'");
        }
    }

    public String execute() {
        this.property.setName(this.newName);
        this.property.setValue(this.newValue);
        this.property.setAddToEnvironment(this.newAddToEnvironment);
        this.property.setAddToPath(this.newAddToPath);
        this.property.setResolveVariables(this.newResolveVariables);
        this.projectManager.save(this.project);
        return "success";
    }
}

