/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.scheduling.SchedulingException;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import com.zutubi.pulse.xwork.interceptor.Preparable;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditProjectAction
extends ProjectActionSupport
implements Preparable {
    private long id;
    private String newName;
    private Project project;
    private static final List<String> ID_PARAMS = Arrays.asList("id");

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public boolean checkProject() {
        if (this.project == null) {
            this.addActionError("Unknown project [" + this.getId() + "]");
            return true;
        }
        return false;
    }

    @Override
    public List<String> getPrepareParameterNames() {
        return ID_PARAMS;
    }

    public void prepare() throws Exception {
        this.project = this.getProjectManager().getProject(this.getId());
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        if (this.checkProject()) {
            return;
        }
        Project existingProject = this.getProjectManager().getProject(this.newName);
        if (existingProject != null && this.getId() != existingProject.getId()) {
            this.addFieldError("newName", this.getText("project.name.exists", Arrays.asList(this.project.getName())));
        }
    }

    public String doInput() {
        if (this.checkProject()) {
            return "error";
        }
        this.newName = this.project.getName();
        return "input";
    }

    public String execute() throws SchedulingException {
        this.getProjectManager().updateProjectDetails(this.project, this.newName, this.project.getDescription(), this.project.getUrl());
        return "success";
    }
}

