/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.model.Cvs;
import com.zutubi.pulse.web.project.AbstractEditScmAction;

public class EditCvsAction
extends AbstractEditScmAction {
    private Cvs scm = new Cvs();
    private String minutes;
    private String seconds;

    public Cvs getScm() {
        return this.scm;
    }

    public String getScmProperty() {
        return "cvs";
    }

    public Cvs getCvs() {
        return this.getScm();
    }

    public void prepare() throws Exception {
        super.prepare();
        this.scm = (Cvs)this.getScmManager().getScm(this.getId());
        this.minutes = this.scm.getQuietPeriodMinutes();
        this.seconds = this.scm.getQuietPeriodSeconds();
    }

    public void validate() {
        try {
            if (TextUtils.stringSet((String)this.minutes) && Integer.parseInt(this.minutes) < 0) {
                this.addFieldError("quiet", this.getText("unit.invalid.negative"));
                return;
            }
            if (TextUtils.stringSet((String)this.seconds) && Integer.parseInt(this.seconds) < 0) {
                this.addFieldError("quiet", this.getText("unit.invalid.negative"));
            }
        }
        catch (NumberFormatException nfe) {
            this.addFieldError("quiet", this.getText("unit.invalid.nan"));
        }
    }

    public String execute() {
        this.getCvs().setQuietPeriod(this.minutes, this.seconds);
        return super.execute();
    }

    public String getMinutes() {
        return this.minutes;
    }

    public void setMinutes(String minutes) {
        this.minutes = minutes;
    }

    public String getSeconds() {
        return this.seconds;
    }

    public void setSeconds(String seconds) {
        this.seconds = seconds;
    }
}

