/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.persistence.BuildSpecificationDao;
import com.zutubi.pulse.web.project.BuildSpecificationActionSupport;
import com.zutubi.pulse.xwork.interceptor.Preparable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditBuildSpecificationAction
extends BuildSpecificationActionSupport
implements Preparable {
    private long id;
    private Project project;
    private BuildSpecification spec;
    private BuildSpecificationDao buildSpecificationDao;
    private boolean isolateChangelists;
    private boolean retainWorkingCopy;
    private boolean timeoutEnabled;
    private boolean prompt;
    private String checkoutSchemeName;
    private int timeout = 60;
    private static final List<String> PREPARE_PARAMS = Arrays.asList("id", "projectId");
    private Map<String, String> checkoutSchemes;

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public BuildSpecification getSpec() {
        return this.spec;
    }

    public boolean isIsolateChangelists() {
        return this.isolateChangelists;
    }

    public void setIsolateChangelists(boolean isolateChangelists) {
        this.isolateChangelists = isolateChangelists;
    }

    public boolean isRetainWorkingCopy() {
        return this.retainWorkingCopy;
    }

    public void setRetainWorkingCopy(boolean retainWorkingCopy) {
        this.retainWorkingCopy = retainWorkingCopy;
    }

    public String getCheckoutSchemeName() {
        return this.checkoutSchemeName;
    }

    public void setCheckoutSchemeName(String checkoutSchemeName) {
        this.checkoutSchemeName = checkoutSchemeName;
    }

    public boolean isTimeoutEnabled() {
        return this.timeoutEnabled;
    }

    public void setTimeoutEnabled(boolean timeoutEnabled) {
        this.timeoutEnabled = timeoutEnabled;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isPrompt() {
        return this.prompt;
    }

    public void setPrompt(boolean prompt) {
        this.prompt = prompt;
    }

    public boolean checkSpec() {
        if (this.spec == null) {
            this.addActionError("Unknown build specification [" + this.getId() + "]");
            return true;
        }
        return false;
    }

    public Map<String, String> getCheckoutSchemes() {
        if (this.checkoutSchemes == null) {
            this.checkoutSchemes = new TreeMap<String, String>();
            if (this.project != null && !this.project.getScm().supportsUpdate()) {
                this.checkoutSchemes.put(BuildSpecification.CheckoutScheme.CLEAN_CHECKOUT.toString(), this.getName(BuildSpecification.CheckoutScheme.CLEAN_CHECKOUT));
            } else {
                for (BuildSpecification.CheckoutScheme scheme : BuildSpecification.CheckoutScheme.values()) {
                    this.checkoutSchemes.put(scheme.toString(), this.getName(scheme));
                }
            }
        }
        return this.checkoutSchemes;
    }

    private String getName(BuildSpecification.CheckoutScheme scheme) {
        return this.getText("buildspec.checkout.scheme." + scheme.toString());
    }

    @Override
    public List<String> getPrepareParameterNames() {
        return PREPARE_PARAMS;
    }

    public void prepare() throws Exception {
        this.project = this.getProjectManager().getProject(this.projectId);
        this.spec = (BuildSpecification)((Object)this.buildSpecificationDao.findById(this.id));
    }

    public void validate() {
        BuildSpecification specOfName;
        if (this.checkSpec()) {
            return;
        }
        if (this.project == null) {
            this.addActionError("Unknown project [" + this.projectId + "]");
            return;
        }
        if (TextUtils.stringSet((String)this.spec.getName()) && (specOfName = this.project.getBuildSpecification(this.spec.getName())) != null && specOfName.getId() != this.id) {
            this.addFieldError("spec.name", "A build specification with name '" + this.spec.getName() + "' already exists in this project.");
        }
        try {
            BuildSpecification.CheckoutScheme scheme = BuildSpecification.CheckoutScheme.valueOf(this.checkoutSchemeName);
            if (scheme != BuildSpecification.CheckoutScheme.CLEAN_CHECKOUT && !this.project.getScm().supportsUpdate()) {
                this.addFieldError("checkoutSchemeName", "Invalid checkout scheme for this project (the SCM does not support updating)");
            }
        }
        catch (IllegalArgumentException e) {
            this.addFieldError("checkoutSchemeName", "Invalid checkout scheme");
        }
        if (this.timeoutEnabled && this.timeout <= 0) {
            this.addFieldError("timeout", "Timeout must be a positive value");
        }
    }

    public String doInput() {
        if (this.checkSpec()) {
            return "error";
        }
        this.isolateChangelists = this.spec.getIsolateChangelists();
        this.retainWorkingCopy = this.spec.getRetainWorkingCopy();
        this.checkoutSchemeName = this.spec.getCheckoutScheme().toString();
        this.timeoutEnabled = this.spec.getTimeout() != 0;
        this.timeout = this.timeoutEnabled ? this.spec.getTimeout() : 60;
        this.prompt = this.spec.getPrompt();
        return "input";
    }

    public String execute() {
        this.projectManager.checkWrite(this.project);
        this.spec.setIsolateChangelists(this.isolateChangelists);
        this.spec.setRetainWorkingCopy(this.retainWorkingCopy);
        BuildSpecification.CheckoutScheme newScheme = BuildSpecification.CheckoutScheme.valueOf(this.checkoutSchemeName);
        if (newScheme != this.spec.getCheckoutScheme()) {
            this.spec.setForceClean(true);
            this.spec.setCheckoutScheme(newScheme);
        }
        if (this.timeoutEnabled) {
            this.spec.setTimeout(this.timeout);
        } else {
            this.spec.setTimeout(0);
        }
        this.spec.setPrompt(this.prompt);
        this.buildSpecificationDao.save(this.spec);
        return "success";
    }

    public void setBuildSpecificationDao(BuildSpecificationDao buildSpecificationDao) {
        this.buildSpecificationDao = buildSpecificationDao;
    }
}

