/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.RandomUtils;
import com.zutubi.pulse.util.TempFileInputStream;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class DownloadDirectoryArtifactAction
extends ProjectActionSupport {
    private long commandId;
    private long id;
    private InputStream inputStream;
    private long contentLength;
    private String filename;
    private MasterConfigurationManager configurationManager;

    public void setCommandId(long commandId) {
        this.commandId = commandId;
    }

    public void setId(long id) {
        this.id = id;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getContentType() {
        return "application/zip";
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getFilename() {
        return this.filename;
    }

    public String execute() {
        CommandResult command = this.getBuildManager().getCommandResult(this.commandId);
        if (command == null) {
            this.addActionError("Unknown command [" + this.id + "]");
            return "error";
        }
        StoredArtifact artifact = this.getBuildManager().getArtifact(this.id);
        if (artifact == null) {
            this.addActionError("Unknown artifact [" + this.id + "]");
            return "error";
        }
        File outputDir = command.getAbsoluteOutputDir(this.configurationManager.getDataDirectory());
        File artifactDir = new File(outputDir, artifact.getName());
        if (!artifactDir.isDirectory()) {
            this.addActionError("LocalArtifact directory '" + artifactDir.getAbsolutePath() + "' does not exist.");
            return "error";
        }
        File tmpRoot = this.configurationManager.getSystemPaths().getTmpRoot();
        if (!tmpRoot.exists()) {
            tmpRoot.mkdirs();
        }
        File temp = new File(tmpRoot, RandomUtils.randomString((int)5) + this.id + ".zip");
        try {
            FileSystemUtils.createZip((File)temp, (File)outputDir, (File)artifactDir);
            this.contentLength = temp.length();
            this.filename = artifact.getName() + ".zip";
            this.inputStream = new TempFileInputStream(temp);
        }
        catch (IOException e) {
            this.addActionError("I/O error zipping directory artifact: " + e.getMessage());
            return "error";
        }
        return "success";
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

