/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DownloadBuildFileAction
extends ProjectActionSupport {
    private long id;
    private InputStream inputStream;
    private long contentLength;
    private MasterConfigurationManager configurationManager;

    public void setId(long id) {
        this.id = id;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getContentType() {
        return "application/xml";
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String execute() throws Exception {
        BuildResult result = this.getBuildManager().getBuildResult(this.id);
        if (result == null) {
            this.addActionError("Unknown build [" + this.id + "]");
            return "error";
        }
        this.checkPermissions(result);
        try {
            File file = new File(result.getAbsoluteOutputDir(this.configurationManager.getDataDirectory()), "pulse.xml");
            this.contentLength = file.length();
            this.inputStream = new FileInputStream(file);
        }
        catch (IOException e) {
            this.addActionError("I/O error opening file: " + e.getMessage());
            return "error";
        }
        return "success";
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

