/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.ValidationAware;
import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.core.ParseException;
import com.zutubi.pulse.core.PulseFile;
import com.zutubi.pulse.core.PulseFileLoader;
import com.zutubi.pulse.core.ResourceRepository;
import com.zutubi.pulse.core.Scope;
import com.zutubi.pulse.core.TypeLoadPredicate;
import com.zutubi.pulse.model.CustomProjectValidationPredicate;
import com.zutubi.pulse.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CustomDetailsHelper {
    private int lineNumber;
    private String line;
    private int lineOffset;

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getLine() {
        return this.line;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    public void validate(ValidationAware action, String pulseFile, ResourceRepository resourceRepository) {
        if (!TextUtils.stringSet((String)pulseFile)) {
            action.addFieldError("details.pulseFile", "pulse file is required");
            return;
        }
        try {
            PulseFileLoader loader = new PulseFileLoader();
            loader.setObjectFactory(new ObjectFactory());
            loader.load((InputStream)new ByteArrayInputStream(pulseFile.getBytes()), (Object)new PulseFile(), new Scope(), resourceRepository, (TypeLoadPredicate)new CustomProjectValidationPredicate());
        }
        catch (ParseException pe) {
            action.addActionError(pe.getMessage());
            if (pe.getLine() > 0) {
                this.line = StringUtils.getLine((String)pulseFile, (int)pe.getLine());
                if (this.line != null) {
                    this.lineNumber = pe.getLine();
                    this.lineOffset = StringUtils.getLineOffset((String)pulseFile, (int)this.lineNumber);
                    action.addActionError("First line of offending element: " + this.line);
                }
            }
        }
        catch (Exception e) {
            action.addActionError(e.getMessage());
        }
    }
}

