/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.core.ResourceRepository;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.BuildSpecificationNode;
import com.zutubi.pulse.web.project.BuildSpecificationActionSupport;

public class CreateBuildSpecificationAction
extends BuildSpecificationActionSupport {
    private BuildSpecification spec = new BuildSpecification();
    private int timeout = 60;
    private boolean timeoutEnabled = false;
    private boolean prompt = false;
    private long specId;

    public BuildSpecification getSpec() {
        return this.spec;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setSpec(BuildSpecification spec) {
        this.spec = spec;
    }

    public long getSpecId() {
        return this.specId;
    }

    public boolean isTimeoutEnabled() {
        return this.timeoutEnabled;
    }

    public void setTimeoutEnabled(boolean timeoutEnabled) {
        this.timeoutEnabled = timeoutEnabled;
    }

    public boolean isPrompt() {
        return this.prompt;
    }

    public void setPrompt(boolean prompt) {
        this.prompt = prompt;
    }

    public String doInput() {
        this.project = this.getProjectManager().getProject(this.projectId);
        return "input";
    }

    public void validate() {
        this.project = this.getProjectManager().getProject(this.projectId);
        if (this.project == null) {
            this.addActionError("Unknown project [" + this.projectId + "]");
            return;
        }
        if (TextUtils.stringSet((String)this.spec.getName()) && this.project.getBuildSpecification(this.spec.getName()) != null) {
            this.addFieldError("spec.name", "A build specification with name '" + this.spec.getName() + "' already exists in this project.");
        }
        if (this.timeoutEnabled && this.timeout <= 0) {
            this.addFieldError("timeout", "Timeout must be a positive value");
        }
        this.lookupAgent();
    }

    public String execute() {
        if (this.timeoutEnabled) {
            this.spec.setTimeout(this.timeout);
        } else {
            this.spec.setTimeout(0);
        }
        this.spec.setPrompt(this.prompt);
        BuildSpecificationNode node = new BuildSpecificationNode(this.stage);
        this.spec.getRoot().addChild(node);
        this.addFieldsToStage();
        this.project.addBuildSpecification(this.spec);
        this.getProjectManager().save(this.project);
        this.specId = this.spec.getId();
        return "success";
    }

    public void setResourceRepository(ResourceRepository resourceRepository) {
        this.resourceRepository = resourceRepository;
    }
}

