/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.CommitMessageTransformer;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectAclEntry;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.scheduling.Trigger;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureProjectAction
extends ProjectActionSupport {
    private long id;
    private Project project;
    private List<Trigger> triggers;
    private UserManager userManager;
    private boolean cleanupInProgress = false;
    private List<CommitMessageTransformer> transformers;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    public boolean isCleanupInProgress() {
        return this.cleanupInProgress;
    }

    public int getDefaultScmPollingInterval() {
        return this.scmManager.getDefaultPollingInterval();
    }

    public List<CommitMessageTransformer> getTransformers() {
        return this.transformers;
    }

    public List<User> getProjectAdmins() {
        LinkedList<User> result = new LinkedList<User>();
        List<ProjectAclEntry> acls = this.project.getAclEntries();
        for (ProjectAclEntry acl : acls) {
            String recipient = (String)acl.getRecipient();
            User user = this.userManager.getUser(recipient);
            if (user == null) continue;
            result.add(user);
        }
        return result;
    }

    public String getSpec(Trigger trigger) {
        BuildSpecification spec;
        Long id = (Long)trigger.getDataMap().get("spec");
        if (id != null && (spec = this.project.getBuildSpecification(id)) != null) {
            return spec.getName();
        }
        return "";
    }

    public boolean isDefault(BuildSpecification specification) {
        return this.project.getDefaultSpecification().equals((Object)specification);
    }

    public void validate() {
        if (this.id != 0L) {
            this.projectId = this.id;
        }
        this.project = super.getProject();
        if (this.project == null) {
            this.addUnknownProjectActionError();
        }
    }

    public String execute() {
        if (this.id != 0L) {
            this.projectId = this.id;
        }
        this.project = super.getProject();
        this.id = this.project.getId();
        this.triggers = this.getScheduler().getTriggers(this.id);
        this.transformers = this.commitMessageTransformerManager.getByProject(this.project);
        this.cleanupInProgress = this.buildManager.isCleanupInProgress(this.project);
        return "success";
    }

    @Override
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

