/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.committransformers.CommitMessageBuilder;
import com.zutubi.pulse.core.model.Changelist;
import com.zutubi.pulse.model.CommitMessageTransformer;
import com.zutubi.pulse.util.logging.Logger;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitMessageSupport {
    private static final Logger LOG = Logger.getLogger(CommitMessageSupport.class);
    private Changelist changelist;
    private List<CommitMessageTransformer> transformers;

    public CommitMessageSupport(Changelist changelist, List<CommitMessageTransformer> transformers) {
        this.transformers = transformers;
        this.changelist = changelist;
    }

    protected CommitMessageBuilder applyTransformers() {
        CommitMessageBuilder builder = new CommitMessageBuilder(this.changelist.getComment());
        for (CommitMessageTransformer transformer : this.transformers) {
            if (!transformer.appliesToChangelist(this.changelist)) continue;
            builder = transformer.transform(builder);
        }
        return builder;
    }

    public int getLength() {
        return this.applyTransformers().getLength();
    }

    public String trim(int length) {
        try {
            CommitMessageBuilder builder = this.applyTransformers();
            builder.trim(length);
            builder.encode();
            return builder.toString();
        }
        catch (Exception e) {
            LOG.warning(String.format("Failed to process changelist comment. Cause: %s", e.getMessage()), (Throwable)e);
            return this.changelist.getComment();
        }
    }

    public String wrap(int length) {
        try {
            CommitMessageBuilder builder = this.applyTransformers();
            builder.wrap(length);
            builder.encode();
            return builder.toString();
        }
        catch (Exception e) {
            LOG.warning(String.format("Failed to process changelist comment. Cause: %s", e.getMessage()), (Throwable)e);
            return this.changelist.getComment();
        }
    }
}

