/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.model.CleanupRule;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanupRuleActionSupport
extends ProjectActionSupport {
    public static final String UNITS_BUILDS = "builds";
    public static final String UNITS_DAYS = "days";
    protected Project project;
    protected boolean workDirOnly = true;
    protected List<String> stateNames;
    protected String buildUnits = "builds";
    protected int limit = 10;

    @Override
    public Project getProject() {
        return this.project;
    }

    public Map<Boolean, String> getWhatMap() {
        TreeMap<Boolean, String> result = new TreeMap<Boolean, String>();
        result.put(true, "working directories only");
        result.put(false, "whole build results");
        return result;
    }

    public boolean getWorkDirOnly() {
        return this.workDirOnly;
    }

    public void setWorkDirOnly(boolean workDirOnly) {
        this.workDirOnly = workDirOnly;
    }

    public Map<String, String> getStateMap() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put(ResultState.ERROR.toString(), "error");
        result.put(ResultState.FAILURE.toString(), "failure");
        result.put(ResultState.SUCCESS.toString(), "success");
        return result;
    }

    public List<String> getStateNames() {
        return this.stateNames;
    }

    public void setStateNames(List<String> stateNames) {
        this.stateNames = stateNames;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getBuildUnits() {
        return this.buildUnits;
    }

    public List<String> getUnitsList() {
        LinkedList<String> units = new LinkedList<String>();
        units.add(UNITS_BUILDS);
        units.add(UNITS_DAYS);
        return units;
    }

    public void setBuildUnits(String buildUnits) {
        this.buildUnits = buildUnits;
    }

    protected ResultState[] calculateResultStates() {
        ResultState[] states = null;
        if (this.stateNames != null && this.stateNames.size() > 0) {
            states = new ResultState[this.stateNames.size()];
            for (int i = 0; i < states.length; ++i) {
                states[i] = ResultState.valueOf((String)this.stateNames.get(i));
            }
        }
        return states;
    }

    protected CleanupRule.CleanupUnit calculateCleanupUnits() {
        CleanupRule.CleanupUnit units = this.buildUnits.equals(UNITS_BUILDS) ? CleanupRule.CleanupUnit.BUILDS : CleanupRule.CleanupUnit.DAYS;
        return units;
    }
}

