/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.NamedEntityComparator;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.scheduling.Trigger;
import com.zutubi.pulse.util.Sort;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildCompletedTriggerHelper {
    private Map<Long, String> filterProjects;
    private Map<Long, List<String>> filterSpecifications;

    public void initialise(ProjectManager projectManager) {
        this.filterProjects = new TreeMap<Long, String>();
        this.filterSpecifications = new LinkedHashMap<Long, List<String>>();
        List<Project> projects = projectManager.getAllProjects();
        Collections.sort(projects, new NamedEntityComparator());
        for (Project p : projects) {
            this.filterProjects.put(p.getId(), p.getName());
            LinkedList<String> specs = new LinkedList<String>();
            for (BuildSpecification spec : p.getBuildSpecifications()) {
                specs.add(spec.getName());
            }
            Collections.sort(specs, new Sort.StringComparator());
            specs.add(0, "");
            this.filterSpecifications.put(p.getId(), specs);
        }
    }

    public void populateTrigger(Trigger trigger, Long filterProject, String filterSpecification, List<String> filterStateNames) {
        Map<Serializable, Serializable> dataMap = trigger.getDataMap();
        dataMap.put((Serializable)((Object)"other.project"), filterProject);
        if (TextUtils.stringSet((String)filterSpecification)) {
            dataMap.put((Serializable)((Object)"other.spec"), (Serializable)((Object)filterSpecification));
        }
        if (filterStateNames != null && filterStateNames.size() > 0) {
            dataMap.put((Serializable)((Object)"build.states"), (Serializable)((Object)ResultState.getStateNamesString(filterStateNames)));
        }
    }

    public Map<Long, String> getFilterProjects() {
        return this.filterProjects;
    }

    public Map<Long, List<String>> getFilterSpecifications() {
        return this.filterSpecifications;
    }

    public Map<String, String> getStateMap() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put(ResultState.ERROR.toString(), "error");
        result.put(ResultState.FAILURE.toString(), "failure");
        result.put(ResultState.SUCCESS.toString(), "success");
        return result;
    }
}

