/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.Validateable;
import com.zutubi.pulse.core.ResourceRepository;
import com.zutubi.pulse.license.LicenseException;
import com.zutubi.pulse.license.Licensed;
import com.zutubi.pulse.model.AntPulseFileDetails;
import com.zutubi.pulse.model.CustomPulseFileDetails;
import com.zutubi.pulse.model.Cvs;
import com.zutubi.pulse.model.DirectoryCapture;
import com.zutubi.pulse.model.ExecutablePulseFileDetails;
import com.zutubi.pulse.model.MakePulseFileDetails;
import com.zutubi.pulse.model.Maven2PulseFileDetails;
import com.zutubi.pulse.model.MavenPulseFileDetails;
import com.zutubi.pulse.model.P4;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.model.PulseFileDetails;
import com.zutubi.pulse.model.Scm;
import com.zutubi.pulse.model.Svn;
import com.zutubi.pulse.model.VersionedPulseFileDetails;
import com.zutubi.pulse.model.XCodePulseFileDetails;
import com.zutubi.pulse.security.AcegiUtils;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.web.project.CustomDetailsHelper;
import com.zutubi.pulse.web.wizard.BaseWizard;
import com.zutubi.pulse.web.wizard.BaseWizardState;
import com.zutubi.pulse.web.wizard.Wizard;
import java.util.Map;
import java.util.TreeMap;
import org.acegisecurity.AccessDeniedException;

@Licensed(value={"canAddProject"})
public class AddProjectWizard
extends BaseWizard {
    private static final Logger LOG = Logger.getLogger(AddProjectWizard.class);
    protected ProjectDetails projectDetails = new ProjectDetails(this, "project");
    private CvsDetails cvsDetails = new CvsDetails(this, "cvs");
    private SvnDetails svnDetails = new SvnDetails(this, "svn");
    private P4Details p4Details = new P4Details(this, "p4");
    private CustomDetails customDetails;
    private VersionedDetails versionedDetails;
    private AntDetails antDetails = new AntDetails(this, "ant");
    private ExecutableDetails executableDetails = new ExecutableDetails(this, "executable");
    private MakeDetails makeDetails = new MakeDetails(this, "make");
    private MavenDetails mavenDetails = new MavenDetails(this, "maven");
    private Maven2Details maven2Details = new Maven2Details(this, "maven2");
    private XCodeDetails xcodeDetails;
    private ProjectManager projectManager;
    private long projectId;

    public AddProjectWizard() {
        this.customDetails = new CustomDetails(this, "custom");
        this.versionedDetails = new VersionedDetails(this, "versioned");
        this.xcodeDetails = new XCodeDetails(this, "xcode");
        this.addInitialState(this.projectDetails);
        this.addState(this.cvsDetails);
        this.addState(this.svnDetails);
        this.addState(this.p4Details);
        this.addState(this.antDetails);
        this.addState(this.executableDetails);
        this.addState(this.makeDetails);
        this.addState(this.mavenDetails);
        this.addState(this.maven2Details);
        this.addState(this.customDetails);
        this.addState(this.versionedDetails);
        this.addState(this.xcodeDetails);
    }

    public void initialise() {
        super.initialise();
        if (!AcegiUtils.userHasRole("ROLE_ADMINISTRATOR")) {
            throw new AccessDeniedException("Access denied");
        }
    }

    public void process() {
        super.process();
        Project project = new Project(this.projectDetails.getName(), this.projectDetails.getDescription());
        project.setUrl(this.projectDetails.getUrl());
        Scm scm = this.getScm();
        scm.setMonitor(true);
        project.setScm(scm);
        PulseFileDetails details = null;
        String projectType = this.projectDetails.getType();
        if ("ant".equals(projectType)) {
            details = this.antDetails.getDetails();
        } else if ("custom".equals(projectType)) {
            details = this.customDetails.getDetails();
        } else if ("executable".equals(projectType)) {
            details = this.executableDetails.getDetails();
        } else if ("make".equals(projectType)) {
            details = this.makeDetails.getDetails();
        } else if ("maven".equals(projectType)) {
            details = this.mavenDetails.getDetails();
        } else if ("maven2".equals(projectType)) {
            details = this.maven2Details.getDetails();
        } else if ("versioned".equals(projectType)) {
            details = this.versionedDetails.getDetails();
        } else if ("xcode".equals(projectType)) {
            details = this.xcodeDetails.getDetails();
        }
        project.setPulseFileDetails(details);
        try {
            this.projectManager.create(project);
            this.projectId = project.getId();
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
    }

    public Scm getScm() {
        Cvs scm = null;
        String scmType = this.projectDetails.getScm();
        if ("cvs".equals(scmType)) {
            scm = this.cvsDetails.getCvs();
        } else if ("svn".equals(scmType)) {
            scm = this.svnDetails.getSvn();
        } else if ("p4".equals(scmType)) {
            scm = this.p4Details.getP4();
        }
        return scm;
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public long getProjectId() {
        return this.projectId;
    }

    private class XCodeDetails
    extends BaseWizardState {
        private XCodePulseFileDetails details;

        public XCodeDetails(Wizard wizard, String name) {
            super(wizard, name);
            this.details = new XCodePulseFileDetails();
        }

        public String getNextStateName() {
            return "success";
        }

        public PulseFileDetails getDetails() {
            return this.details;
        }
    }

    private class VersionedDetails
    extends BaseWizardState {
        private PulseFileDetails details;

        public VersionedDetails(Wizard wizard, String name) {
            super(wizard, name);
            this.details = new VersionedPulseFileDetails("pulse.xml");
        }

        public String getNextStateName() {
            return "success";
        }

        public PulseFileDetails getDetails() {
            return this.details;
        }
    }

    private class CustomDetails
    extends BaseWizardState
    implements Validateable {
        private CustomPulseFileDetails details;
        private CustomDetailsHelper detailsHelper;
        private ResourceRepository resourceRepository;

        public CustomDetails(Wizard wizard, String name) {
            super(wizard, name);
            this.details = new CustomPulseFileDetails("<?xml version=\"1.0\"?>\n<project>\n</project>\n");
            this.detailsHelper = new CustomDetailsHelper();
        }

        public String getNextStateName() {
            return "success";
        }

        public PulseFileDetails getDetails() {
            return this.details;
        }

        public CustomDetailsHelper getDetailsHelper() {
            return this.detailsHelper;
        }

        public void validate() {
            this.detailsHelper.validate(this.getWizard(), this.details.getPulseFile(), this.resourceRepository);
        }

        public void setResourceRepository(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }
    }

    private class Maven2Details
    extends BaseWizardState {
        private Maven2PulseFileDetails details;

        public Maven2Details(Wizard wizard, String name) {
            super(wizard, name);
            this.details = new Maven2PulseFileDetails();
        }

        public String getNextStateName() {
            return "success";
        }

        public PulseFileDetails getDetails() {
            return this.details;
        }

        public void execute() {
            DirectoryCapture testCapture = new DirectoryCapture("test reports");
            testCapture.setIncludes("**/target/surefire-reports/TEST-*.xml");
            testCapture.addProcessor("junit");
            this.details.addCapture(testCapture);
        }
    }

    private class MavenDetails
    extends BaseWizardState {
        private MavenPulseFileDetails details;

        public MavenDetails(Wizard wizard, String name) {
            super(wizard, name);
            this.details = new MavenPulseFileDetails();
        }

        public String getNextStateName() {
            return "success";
        }

        public PulseFileDetails getDetails() {
            return this.details;
        }

        public void execute() {
            DirectoryCapture testCapture = new DirectoryCapture("test reports");
            testCapture.setIncludes("**/target/test-reports/TEST-*.xml");
            testCapture.addProcessor("junit");
            this.details.addCapture(testCapture);
        }
    }

    private class MakeDetails
    extends BaseWizardState {
        private MakePulseFileDetails details;

        public MakeDetails(Wizard wizard, String name) {
            super(wizard, name);
            this.details = new MakePulseFileDetails("Makefile", null, null, null);
        }

        public String getNextStateName() {
            return "success";
        }

        public PulseFileDetails getDetails() {
            return this.details;
        }
    }

    private class ExecutableDetails
    extends BaseWizardState {
        private ExecutablePulseFileDetails details;

        public ExecutableDetails(Wizard wizard, String name) {
            super(wizard, name);
            this.details = new ExecutablePulseFileDetails("", null, null, null);
        }

        public String getNextStateName() {
            return "success";
        }

        public PulseFileDetails getDetails() {
            return this.details;
        }
    }

    private class AntDetails
    extends BaseWizardState {
        private AntPulseFileDetails details;

        public AntDetails(Wizard wizard, String name) {
            super(wizard, name);
            this.details = new AntPulseFileDetails("build.xml", null, null, null, null);
        }

        public String getNextStateName() {
            return "success";
        }

        public PulseFileDetails getDetails() {
            return this.details;
        }
    }

    private class P4Details
    extends BaseWizardState {
        private P4 p4;

        public P4Details(Wizard wizard, String name) {
            super(wizard, name);
            this.p4 = new P4();
            String value = System.getenv("P4PORT");
            if (value == null) {
                this.p4.setPort("perforce:1666");
            } else {
                this.p4.setPort(value);
            }
            value = System.getenv("P4USER");
            if (value != null) {
                this.p4.setUser(value);
            }
            if ((value = System.getenv("P4CLIENT")) != null) {
                this.p4.setClient(value);
            }
        }

        public P4 getP4() {
            return this.p4;
        }

        public String getNextStateName() {
            return ((AddProjectWizard)this.getWizard()).projectDetails.getType();
        }
    }

    private class SvnDetails
    extends BaseWizardState {
        private Svn svn;

        public SvnDetails(Wizard wizard, String name) {
            super(wizard, name);
            this.svn = new Svn();
        }

        public Svn getSvn() {
            return this.svn;
        }

        public String getNextStateName() {
            return ((AddProjectWizard)this.getWizard()).projectDetails.getType();
        }
    }

    private class CvsDetails
    extends BaseWizardState
    implements Validateable {
        private Cvs cvs;
        private String minutes;
        private String seconds;

        public CvsDetails(Wizard wizard, String name) {
            super(wizard, name);
            this.cvs = new Cvs();
        }

        public Cvs getCvs() {
            return this.cvs;
        }

        public String getMinutes() {
            return this.minutes;
        }

        public void setMinutes(String minutes) {
            this.minutes = minutes;
        }

        public String getSeconds() {
            return this.seconds;
        }

        public void setSeconds(String seconds) {
            this.seconds = seconds;
        }

        public String getNextStateName() {
            this.cvs.setQuietPeriod(this.minutes, this.seconds);
            return ((AddProjectWizard)this.getWizard()).projectDetails.getType();
        }

        public void validate() {
            try {
                if (TextUtils.stringSet((String)this.minutes) && Integer.parseInt(this.minutes) < 0) {
                    this.addFieldError("quiet", AddProjectWizard.this.getTextProvider().getText("unit.invalid.negative"));
                    return;
                }
                if (TextUtils.stringSet((String)this.seconds) && Integer.parseInt(this.seconds) < 0) {
                    this.addFieldError("quiet", AddProjectWizard.this.getTextProvider().getText("unit.invalid.negative"));
                }
            }
            catch (NumberFormatException nfe) {
                this.addFieldError("quiet", AddProjectWizard.this.getTextProvider().getText("unit.invalid.nan"));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProjectDetails
    extends BaseWizardState
    implements Validateable {
        private Map<String, String> scms;
        private Map<String, String> types;
        private String scm;
        private String type;
        private String name;
        private String description;
        private String url;

        public ProjectDetails(Wizard wizard, String name) {
            super(wizard, name);
            this.scms = null;
            this.types = null;
        }

        public Map<String, String> getScms() {
            if (this.scms == null) {
                this.scms = new TreeMap<String, String>();
                this.scms.put("cvs", "cvs");
                this.scms.put("p4", "perforce");
                this.scms.put("svn", "subversion");
            }
            return this.scms;
        }

        public Map<String, String> getTypes() {
            if (this.types == null) {
                this.types = new TreeMap<String, String>();
                this.types.put("ant", "ant project");
                this.types.put("custom", "custom project");
                this.types.put("executable", "executable project");
                this.types.put("make", "make project");
                this.types.put("maven", "maven project");
                this.types.put("maven2", "maven 2 project");
                this.types.put("versioned", "versioned project");
                this.types.put("xcode", "xcode project");
            }
            return this.types;
        }

        public void validate() {
            if (!this.types.containsKey(this.type)) {
                this.addActionError("An invalid type has been requested. Please select one of the options from the drop down list provided.");
            }
            if (!this.scms.containsKey(this.scm)) {
                this.addActionError("An invalid scm has been requested. Please select one of the options from the drop down list provided.");
            }
            if (AddProjectWizard.this.projectManager.getProject(this.name) != null) {
                this.addFieldError("name", "The name " + this.name + " is already being used by another project. " + "Please select a different name.");
            }
        }

        @Override
        public String getNextStateName() {
            return this.scm;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getScm() {
            return this.scm;
        }

        public void setScm(String scm) {
            this.scm = scm;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

