/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.Validateable;
import com.zutubi.pulse.PostProcessorManager;
import com.zutubi.pulse.model.Capture;
import com.zutubi.pulse.model.DirectoryCapture;
import com.zutubi.pulse.model.FileCapture;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.model.TemplatePulseFileDetails;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.web.wizard.BaseWizard;
import com.zutubi.pulse.web.wizard.BaseWizardState;
import com.zutubi.pulse.web.wizard.Wizard;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AddArtifactWizard
extends BaseWizard {
    private static final String DIRECTORY_STATE = "dir";
    private static final String FILE_STATE = "file";
    private static final String PROCESSORS_STATE = "processors";
    private static final Logger LOG = Logger.getLogger(AddArtifactWizard.class);
    private long projectId;
    private Project project;
    private ProjectManager projectManager;
    private PostProcessorManager postProcessorManager;
    private SelectArtifactType selectState = new SelectArtifactType(this, "select");
    private ConfigureDirectoryArtifact configDir = new ConfigureDirectoryArtifact(this, "dir");
    private ConfigureFileArtifact configFile = new ConfigureFileArtifact(this, "file");
    private ConfigureProcessors configProcessors = new ConfigureProcessors(this);

    public AddArtifactWizard() {
        this.addInitialState(this.selectState);
        this.addState(this.configDir);
        this.addState(this.configFile);
        this.addState(this.configProcessors);
    }

    public long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    public Project getProject() {
        if (this.project == null) {
            this.project = this.projectManager.getProject(this.projectId);
        }
        return this.project;
    }

    public void process() {
        Project project = this.projectManager.getProject(this.getProjectId());
        Capture capture = DIRECTORY_STATE.equals(this.selectState.getType()) ? this.configDir.getCapture() : this.configFile.getCapture();
        for (String processor : this.configProcessors.getProcessors()) {
            capture.addProcessor(processor);
        }
        capture.clearFields();
        TemplatePulseFileDetails details = (TemplatePulseFileDetails)project.getPulseFileDetails();
        details.addCapture(capture);
        this.projectManager.save(project);
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public void setPostProcessorManager(PostProcessorManager postProcessorManager) {
        this.postProcessorManager = postProcessorManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConfigureProcessors
    extends BaseWizardState {
        private Map<String, String> processorList;
        private List<String> processors;

        public ConfigureProcessors(Wizard wizard) {
            super(wizard, AddArtifactWizard.PROCESSORS_STATE);
            this.processors = new LinkedList<String>();
        }

        public Map<String, String> getProcessorList() {
            if (this.processorList == null) {
                this.processorList = AddArtifactWizard.this.postProcessorManager.getAvailableProcessors();
            }
            return this.processorList;
        }

        public List<String> getProcessors() {
            return this.processors;
        }

        public void setProcessors(List<String> processors) {
            this.processors = processors;
        }

        @Override
        public String getNextStateName() {
            return "success";
        }
    }

    public class ConfigureFileArtifact
    extends BaseWizardState {
        private FileCapture capture;

        public ConfigureFileArtifact(Wizard wizard, String stateName) {
            super(wizard, stateName);
        }

        public FileCapture getCapture() {
            if (this.capture == null) {
                this.capture = new FileCapture(AddArtifactWizard.this.selectState.getName(), null);
            }
            return this.capture;
        }

        public String getNextStateName() {
            return AddArtifactWizard.PROCESSORS_STATE;
        }
    }

    public class ConfigureDirectoryArtifact
    extends BaseWizardState {
        private DirectoryCapture capture;

        public ConfigureDirectoryArtifact(Wizard wizard, String stateName) {
            super(wizard, stateName);
        }

        public DirectoryCapture getCapture() {
            if (this.capture == null) {
                this.capture = new DirectoryCapture(AddArtifactWizard.this.selectState.getName());
            }
            return this.capture;
        }

        public String getNextStateName() {
            return AddArtifactWizard.PROCESSORS_STATE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SelectArtifactType
    extends BaseWizardState
    implements Validateable {
        private Map<String, String> types;
        private String name;
        private String type;

        public SelectArtifactType(Wizard wizard, String name) {
            super(wizard, name);
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Map<String, String> getTypes() {
            return this.types;
        }

        public void validate() {
            if (!TextUtils.stringSet((String)this.type) || !this.types.containsKey(this.type)) {
                this.addFieldError("type", "Invalid type '" + this.type + "' specified.");
                return;
            }
            TemplatePulseFileDetails details = (TemplatePulseFileDetails)AddArtifactWizard.this.getProject().getPulseFileDetails();
            if (details.getCapture(this.name) != null) {
                this.addFieldError("name", "the name " + this.name + " is already being used.");
            }
        }

        @Override
        public void initialise() {
            super.initialise();
            if (AddArtifactWizard.this.getProject() == null) {
                this.addActionError("Unknown project [" + AddArtifactWizard.this.projectId + "]");
                return;
            }
            if (this.types == null) {
                this.types = new TreeMap<String, String>();
                this.types.put(AddArtifactWizard.DIRECTORY_STATE, "directory artifact");
                this.types.put(AddArtifactWizard.FILE_STATE, "file artifact");
            }
        }

        @Override
        public String getNextStateName() {
            if (TextUtils.stringSet((String)this.type)) {
                return this.type;
            }
            return super.getStateName();
        }
    }
}

