/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.scheduling.Scheduler;
import com.zutubi.pulse.scheduling.SchedulingException;
import com.zutubi.pulse.scheduling.Trigger;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import com.zutubi.pulse.xwork.interceptor.Preparable;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEditTriggerAction
extends ProjectActionSupport
implements Preparable {
    private long id;
    private Project project;
    private long specification;
    private Map<Long, String> specifications;
    private static final List<String> ID_PARAMS = Arrays.asList("id", "projectId");

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public Map<Long, String> getSpecifications() {
        return this.specifications;
    }

    public long getSpecification() {
        return this.specification;
    }

    public void setSpecification(long specification) {
        this.specification = specification;
    }

    @Override
    public List<String> getPrepareParameterNames() {
        return ID_PARAMS;
    }

    public void prepare() throws Exception {
        this.project = this.getProjectManager().getProject(this.projectId);
        if (this.project == null) {
            this.addActionError("Unknown project [" + this.projectId + "]");
            return;
        }
        this.specifications = new LinkedHashMap<Long, String>();
        for (BuildSpecification spec : this.project.getBuildSpecifications()) {
            this.specifications.put(spec.getId(), spec.getName());
        }
        Trigger trigger = this.getTrigger();
        this.specification = (Long)trigger.getDataMap().get("spec");
    }

    public String doInput() {
        if (this.hasErrors()) {
            return "error";
        }
        return "input";
    }

    public String execute() {
        if (this.hasErrors()) {
            return "error";
        }
        try {
            Scheduler scheduler = this.getScheduler();
            Trigger trigger = this.getTrigger();
            trigger.getDataMap().put((Serializable)((Object)"spec"), Long.valueOf(this.specification));
            scheduler.update(trigger);
            return "success";
        }
        catch (SchedulingException e) {
            this.addActionError("Unable to update trigger: " + e.getMessage());
            return "error";
        }
    }

    public abstract Trigger getTrigger();
}

