/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.Scm;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import com.zutubi.pulse.xwork.interceptor.Preparable;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEditScmAction
extends ProjectActionSupport
implements Preparable {
    private long id;
    private Project project;
    private static final List<String> ID_PARAMS = Arrays.asList("id", "projectId");
    private boolean monitor;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean isMonitor() {
        return this.monitor;
    }

    public void setMonitor(boolean active) {
        this.monitor = active;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public List<String> getPrepareParameterNames() {
        return ID_PARAMS;
    }

    public void prepare() throws Exception {
        this.project = this.getProjectManager().getProject(this.projectId);
    }

    public String doInput() {
        this.monitor = this.project.getScm().isMonitor();
        return "input";
    }

    public String execute() {
        this.getScm().setMonitor(this.monitor);
        this.getScmManager().save(this.getScm());
        this.project = this.getProjectManager().getProject(this.projectId);
        for (BuildSpecification spec : this.project.getBuildSpecifications()) {
            spec.setForceClean(true);
            this.getProjectManager().save(spec);
        }
        return "success";
    }

    public abstract Scm getScm();

    public abstract String getScmProperty();
}

