/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.project;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.filesystem.File;
import com.zutubi.pulse.filesystem.FileSystem;
import com.zutubi.pulse.filesystem.FileSystemException;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.web.DirectoryEntry;
import com.zutubi.pulse.web.project.ProjectActionSupport;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBrowseDirAction
extends ProjectActionSupport {
    private String path = "";
    private List<DirectoryEntry> entries;
    private InputStream inputStream;
    private String contentType;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<DirectoryEntry> getEntries() {
        return this.entries;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getDisplayPath() {
        String result = FileSystemUtils.normaliseSeparators((String)this.path);
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    public boolean getShowSizes() {
        return true;
    }

    private void createDirectoryEntries(FileSystem fs, File dir) throws FileSystemException {
        this.entries = new LinkedList<DirectoryEntry>();
        if (TextUtils.stringSet((String)this.path)) {
            File parentFile = dir.getParentFile();
            this.entries.add(new DirectoryEntry(parentFile, ".."));
        }
        Object[] files = fs.list(dir);
        Arrays.sort(files);
        for (Object f : files) {
            this.entries.add(new DirectoryEntry((File)f, f.getName()));
        }
    }

    public String execute(FileSystem fs) {
        try {
            File file = fs.getFile(this.path);
            if (file.isDirectory()) {
                this.createDirectoryEntries(fs, file);
                return "dir";
            }
            if (file.isFile()) {
                this.inputStream = fs.getFileContents(file);
                this.contentType = fs.getMimeType(file);
                return "file";
            }
        }
        catch (FileSystemException fse) {
            this.addActionError(fse.getMessage());
            return "error";
        }
        this.addActionError("Path '" + this.path + "' does not exist");
        return "error";
    }
}

