/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.ajax;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.model.EmailContactPoint;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.web.ActionSupport;

public class TestSmtpAction
extends ActionSupport {
    private static final Logger LOG = Logger.getLogger(TestSmtpAction.class);
    private String host;
    private boolean customPort;
    private int port;
    private boolean ssl;
    private String from;
    private String username;
    private String password;
    private String prefix;
    private String to;

    public void setHost(String host) {
        this.host = host;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setCustomPort(boolean customPort) {
        this.customPort = customPort;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public String execute() throws Exception {
        if (!TextUtils.stringSet((String)this.host)) {
            this.addActionError(this.getText("smtp.host.required"));
        }
        if (!TextUtils.stringSet((String)this.from)) {
            this.addActionError(this.getText("smtp.from.required"));
        }
        if (!TextUtils.stringSet((String)this.to)) {
            this.addActionError(this.getText("smtp.to.required"));
        }
        if (!this.hasErrors()) {
            try {
                if (!this.customPort) {
                    this.port = -1;
                }
                EmailContactPoint.sendMail(this.to, this.prefix + " Test Email", "text/plain", "Welcome to Zutubi Pulse!", this.host, this.port, this.ssl, this.username, this.password, this.from);
            }
            catch (Exception e) {
                LOG.severe("Unable to send test email: " + e.getMessage(), (Throwable)e);
                this.addActionError(e.getMessage() + " (see logs for further details)");
            }
        }
        return "success";
    }
}

