/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.ajax;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.model.Group;
import com.zutubi.pulse.security.ldap.LdapManager;
import com.zutubi.pulse.web.ActionSupport;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLdapAction
extends ActionSupport {
    private LdapManager ldapManager;
    private String host;
    private String baseDn;
    private String managerDn;
    private String managerPassword;
    private String userFilter;
    private String groupDn;
    private String groupFilter;
    private String groupRoleAttribute;
    private boolean groupSearchSubtree;
    private boolean escapeSpaces;
    private String login;
    private String password;
    private List<Group> groups;

    public List<Group> getGroups() {
        return this.groups;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    public void setManagerDn(String managerDn) {
        this.managerDn = managerDn;
    }

    public void setManagerPassword(String managerPassword) {
        this.managerPassword = managerPassword;
    }

    public void setEscapeSpaces(boolean escapeSpaces) {
        this.escapeSpaces = escapeSpaces;
    }

    public void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
    }

    public void setGroupDn(String groupDn) {
        this.groupDn = groupDn;
    }

    public void setGroupFilter(String groupFilter) {
        this.groupFilter = groupFilter;
    }

    public void setGroupRoleAttribute(String groupRoleAttribute) {
        this.groupRoleAttribute = groupRoleAttribute;
    }

    public void setGroupSearchSubtree(boolean groupSearchSubtree) {
        this.groupSearchSubtree = groupSearchSubtree;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String execute() throws Exception {
        if (!TextUtils.stringSet((String)this.host)) {
            this.addActionError(this.getText("ldap.host.url.required"));
        }
        if (!TextUtils.stringSet((String)this.baseDn)) {
            this.addActionError(this.getText("ldap.base.dn.required"));
        }
        if (!TextUtils.stringSet((String)this.login)) {
            this.addActionError(this.getText("ldap.test.login.required"));
        }
        if (!this.hasErrors()) {
            try {
                this.groups = this.ldapManager.testAuthenticate(this.host, this.baseDn, this.managerDn, this.managerPassword, this.userFilter, this.groupDn, this.groupFilter, this.groupRoleAttribute, this.groupSearchSubtree, this.escapeSpaces, this.login, this.password);
            }
            catch (Exception e) {
                this.addActionError(e.getMessage());
            }
        }
        return "success";
    }

    public void setLdapManager(LdapManager ldapManager) {
        this.ldapManager = ldapManager;
    }
}

