/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.ajax;

import com.opensymphony.xwork.LocaleProvider;
import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork.validator.DefaultActionValidatorManager;
import com.opensymphony.xwork.validator.DelegatingValidatorContext;
import com.opensymphony.xwork.validator.ValidationException;
import com.opensymphony.xwork.validator.ValidatorContext;
import com.zutubi.pulse.model.Scm;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.SCMServer;
import com.zutubi.pulse.web.ActionSupport;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class BaseTestScmAction
extends ActionSupport {
    private DefaultActionValidatorManager validationManager = new DefaultActionValidatorManager();

    public abstract Scm getScm();

    public String execute() {
        Scm scm = this.getScm();
        try {
            this.validationManager.validate((Object)scm, scm.getClass().getName(), (ValidatorContext)new DelegatingValidatorContext((ValidationAware)this, (TextProvider)this, (LocaleProvider)this));
        }
        catch (ValidationException e) {
            // empty catch block
        }
        if (this.hasErrors()) {
            return "success";
        }
        FutureTask<String> task = new FutureTask<String>(new Tester(scm));
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.execute(task);
        try {
            String error = task.get(30L, TimeUnit.SECONDS);
            if (error != null) {
                this.addActionError(error);
            }
        }
        catch (TimeoutException e) {
            this.addActionError("Connection test timed out (after 30 seconds)");
        }
        catch (Exception e) {
            this.addActionError(e.getMessage());
        }
        return "success";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Tester
    implements Callable<String> {
        private Scm scm;

        public Tester(Scm scm) {
            this.scm = scm;
        }

        @Override
        public String call() throws Exception {
            try {
                SCMServer server = this.scm.createServer();
                server.testConnection();
                return null;
            }
            catch (SCMException e) {
                return e.getMessage();
            }
        }
    }
}

