/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.agents;

import com.zutubi.pulse.logging.CustomLogRecord;
import com.zutubi.pulse.web.PagingSupport;
import com.zutubi.pulse.web.agents.ServerMessagesActionSupport;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerMessagesAction
extends ServerMessagesActionSupport {
    private List<CustomLogRecord> records;
    private PagingSupport pagingSupport = new PagingSupport(10);

    public List<CustomLogRecord> getRecords() {
        return this.records;
    }

    public void setStartPage(int page) {
        this.pagingSupport.setStartPage(page);
    }

    public PagingSupport getPagingSupport() {
        return this.pagingSupport;
    }

    public String execute() throws Exception {
        this.lookupSlave();
        if (this.getAgent().isOnline()) {
            try {
                this.records = this.getAgent().getRecentMessages();
                Collections.reverse(this.records);
                this.pagingSupport.setTotalItems(this.records.size());
                this.records = this.records.subList(this.pagingSupport.getStartOffset(), this.pagingSupport.getEndOffset());
            }
            catch (RuntimeException e) {
                this.addActionError("Unable to contact agent: " + e.getMessage());
            }
        } else {
            this.addActionError("Agent is not online.");
        }
        return "success";
    }
}

