/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.agents;

import com.zutubi.pulse.agent.AgentManager;
import com.zutubi.pulse.model.Slave;
import com.zutubi.pulse.model.SlaveManager;
import com.zutubi.pulse.web.ActionSupport;

public class EditAgentAction
extends ActionSupport {
    private long id;
    private Slave slave = new Slave();
    private AgentManager agentManager;
    private SlaveManager slaveManager;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Slave getSlave() {
        return this.slave;
    }

    public String doInput() {
        this.slave = this.slaveManager.getSlave(this.id);
        return "input";
    }

    public void validate() {
        Slave persistentSlave = this.slaveManager.getSlave(this.id);
        if (persistentSlave == null) {
            this.addActionError("Unknown agent [" + this.id + "]");
            return;
        }
        if (!this.slave.getName().equals(persistentSlave.getName()) && this.slaveManager.getSlave(this.slave.getName()) != null) {
            this.addFieldError("slave.name", "An agent with name '" + this.slave.getName() + "' already exists.");
        }
    }

    public String execute() {
        Slave persistentSlave = this.slaveManager.getSlave(this.id);
        persistentSlave.setHost(this.slave.getHost());
        persistentSlave.setName(this.slave.getName());
        persistentSlave.setPort(this.slave.getPort());
        this.slaveManager.save(persistentSlave);
        this.agentManager.slaveChanged(persistentSlave.getId());
        return "success";
    }

    public void setSlaveManager(SlaveManager slaveManager) {
        this.slaveManager = slaveManager;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }
}

