/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin.user;

import com.zutubi.pulse.model.Group;
import com.zutubi.pulse.model.NamedEntityComparator;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.web.admin.user.GroupActionSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupBasicsActionSupport
extends GroupActionSupport {
    private boolean admin;
    private boolean personal;
    private boolean adminAllProjects;
    private Map<Long, String> allProjects;
    private List<Long> projects = new ArrayList<Long>();
    private int startPage = 0;

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public boolean isPersonal() {
        return this.personal;
    }

    public void setPersonal(boolean personal) {
        this.personal = personal;
    }

    public boolean isAdminAllProjects() {
        return this.adminAllProjects;
    }

    public void setAdminAllProjects(boolean adminAllProjects) {
        this.adminAllProjects = adminAllProjects;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public Map<Long, String> getAllProjects() {
        if (this.allProjects == null) {
            this.allProjects = new LinkedHashMap<Long, String>();
            List<Project> all = this.getProjectManager().getAllProjects();
            Collections.sort(all, new NamedEntityComparator());
            for (Project p : all) {
                this.allProjects.put(p.getId(), p.getName());
            }
        }
        return this.allProjects;
    }

    public List<Long> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Long> projects) {
        this.projects = projects;
    }

    protected void setPermissions(Group group) {
        if (this.isAdmin()) {
            group.addAdditionalAuthority("ROLE_ADMINISTRATOR");
        } else {
            group.removeAdditionalAuthority("ROLE_ADMINISTRATOR");
        }
        if (this.isPersonal()) {
            group.addAdditionalAuthority("ROLE_PERSONAL");
        } else {
            group.removeAdditionalAuthority("ROLE_PERSONAL");
        }
        group.setAdminAllProjects(this.isAdminAllProjects());
        this.getUserManager().save(group);
        List<Long> projects = null;
        if (!group.getAdminAllProjects()) {
            projects = this.getProjects();
        }
        this.getProjectManager().updateProjectAdmins(group.getDefaultAuthority(), projects);
    }
}

