/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin.user;

import com.zutubi.pulse.model.User;
import com.zutubi.pulse.web.user.UserActionSupport;
import java.util.Arrays;

public class EditUserAction
extends UserActionSupport {
    private String newLogin;
    private String newName;
    private boolean ldapAuthentication;
    private int startPage = 0;

    public String getNewLogin() {
        return this.newLogin;
    }

    public void setNewLogin(String newLogin) {
        this.newLogin = newLogin;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public boolean isLdapAuthentication() {
        return this.ldapAuthentication;
    }

    public void setLdapAuthentication(boolean ldapAuthentication) {
        this.ldapAuthentication = ldapAuthentication;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public String doInput() {
        User user = this.getUser();
        this.startPage = this.getUserStartPage(user);
        this.newLogin = user.getLogin();
        this.newName = user.getName();
        this.ldapAuthentication = user.getLdapAuthentication();
        return "input";
    }

    public void validate() {
        User byLogin = this.getUserManager().getUser(this.newLogin);
        if (byLogin != null && byLogin.getId() != this.getUserId()) {
            this.addFieldError("newLogin", this.getText("user.login.exists", Arrays.asList(this.newLogin)));
        }
    }

    public String execute() {
        User persistentUser = this.getUser();
        if (this.isAdminUser(persistentUser)) {
            this.getConfigurationManager().getAppConfig().setAdminLogin(this.newLogin);
        } else {
            persistentUser.setLdapAuthentication(this.ldapAuthentication);
        }
        persistentUser.setLogin(this.newLogin);
        persistentUser.setName(this.newName);
        this.getUserManager().save(persistentUser);
        this.startPage = this.getUserStartPage(persistentUser);
        return "success";
    }
}

