/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin.user;

import com.zutubi.pulse.model.Group;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.web.admin.user.GroupBasicsActionSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EditGroupAction
extends GroupBasicsActionSupport {
    private String newName;

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String doInput() {
        Group group = this.getGroup();
        if (group == null) {
            this.addActionError("Unknown group [" + this.getGroupId() + "]");
            return "error";
        }
        this.setStartPage(this.getGroupStartPage(group));
        this.newName = group.getName();
        this.setAdmin(this.hasAdminAuthority(group));
        this.setPersonal(this.hasPersonalAuthority(group));
        this.setAdminAllProjects(group.getAdminAllProjects());
        List<Project> adminProjects = this.getProjectManager().getProjectsWithAdmin(group.getDefaultAuthority());
        ArrayList<Long> projects = new ArrayList<Long>(adminProjects.size());
        for (Project p : adminProjects) {
            projects.add(p.getId());
        }
        this.setProjects(projects);
        return "input";
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        if (this.getGroup() == null) {
            this.addActionError("Unknown group [" + this.getGroupId() + "]");
            return;
        }
        if (!this.newName.equals(this.getGroup().getName()) && this.getUserManager().getGroup(this.newName) != null) {
            this.addFieldError("newName", this.getText("group.name.duplicate", Arrays.asList(this.newName)));
        }
    }

    public String execute() {
        Group group = this.getGroup();
        group.setName(this.newName);
        this.setPermissions(group);
        this.setStartPage(this.getGroupStartPage(group));
        return "success";
    }
}

