/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin.user;

import com.zutubi.pulse.license.Licensed;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.web.user.UserActionSupport;
import java.util.Arrays;

@Licensed(value={"canAddUser"})
public class CreateUserAction
extends UserActionSupport {
    protected User newUser = new User();
    private String confirm;
    private boolean ldapAuthentication = false;
    private int startPage = 0;

    public User getNewUser() {
        return this.newUser;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public boolean isLdapAuthentication() {
        return this.ldapAuthentication;
    }

    public void setLdapAuthentication(boolean ldapAuthentication) {
        this.ldapAuthentication = ldapAuthentication;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        if (!this.ldapAuthentication && !this.confirm.equals(this.newUser.getPassword())) {
            this.addFieldError("confirm", this.getText("password.confirm.mismatch"));
        }
        if (this.getUserManager().getUser(this.newUser.getLogin()) != null) {
            this.addFieldError("newUser.login", this.getText("user.login.exists", Arrays.asList(this.newUser.getLogin())));
        }
    }

    public String execute() throws Exception {
        this.getUserManager().addUser(this.newUser, false, this.ldapAuthentication);
        this.startPage = this.getUserStartPage(this.newUser);
        this.doReset();
        return "success";
    }

    public void doReset() {
        this.newUser = new User();
    }
}

