/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin.debug;

import com.zutubi.pulse.web.ActionSupport;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.SessionFactory;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumpHibernateStatisticsAction
extends ActionSupport {
    private SessionFactory sessionFactory;
    private boolean on;
    private Statistics stats;
    private long secondLevelCacheSize = 0L;
    private Map<String, SecondLevelCacheStatistics> secondLevelCacheStats = new TreeMap<String, SecondLevelCacheStatistics>();
    private Map<String, QueryStatistics> queryStats = new TreeMap<String, QueryStatistics>();
    private Map<String, EntityStatistics> entityStats = new TreeMap<String, EntityStatistics>();

    public boolean isOn() {
        return this.on;
    }

    public Statistics getStats() {
        return this.stats;
    }

    public long getSecondLevelCacheSize() {
        return this.secondLevelCacheSize;
    }

    public String getSecondLevelCacheSizeKB() {
        return String.format("%.02f", (double)this.secondLevelCacheSize / 1024.0);
    }

    public Map<String, QueryStatistics> getQueryStats() {
        return this.queryStats;
    }

    public Map<String, EntityStatistics> getEntityStats() {
        return this.entityStats;
    }

    public String getSecondLevelCacheSizeMB() {
        return String.format("%.02f", (double)this.secondLevelCacheSize / 1048576.0);
    }

    public Map<String, SecondLevelCacheStatistics> getSecondLevelCacheStats() {
        return this.secondLevelCacheStats;
    }

    public String execute() throws Exception {
        this.stats = this.sessionFactory.getStatistics();
        this.on = this.stats.isStatisticsEnabled();
        if (this.on) {
            for (String region : this.stats.getSecondLevelCacheRegionNames()) {
                SecondLevelCacheStatistics regionStats = this.stats.getSecondLevelCacheStatistics(region);
                this.secondLevelCacheSize += regionStats.getSizeInMemory();
                this.secondLevelCacheStats.put(region, regionStats);
            }
            for (String query : this.stats.getQueries()) {
                this.queryStats.put(query, this.stats.getQueryStatistics(query));
            }
            for (String entity : this.stats.getEntityNames()) {
                this.entityStats.put(entity, this.stats.getEntityStatistics(entity));
            }
        }
        return "success";
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

