/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin;

import com.zutubi.pulse.bootstrap.MasterConfiguration;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.jabber.JabberManager;
import com.zutubi.pulse.web.ActionSupport;

public class JabberConfigurationAction
extends ActionSupport {
    private MasterConfigurationManager configurationManager;
    private JabberConfig jabber = new JabberConfig();
    private JabberManager jabberManager;

    public JabberConfig getJabber() {
        return this.jabber;
    }

    public String doReset() {
        this.resetConfig();
        this.loadConfig();
        return "success";
    }

    public String doSave() {
        this.saveConfig();
        return "success";
    }

    public String doInput() {
        this.loadConfig();
        return "input";
    }

    public String doRefresh() {
        this.jabberManager.refresh();
        return "success";
    }

    public String execute() {
        this.loadConfig();
        return "success";
    }

    private void resetConfig() {
        MasterConfiguration config = this.configurationManager.getAppConfig();
        config.setJabberHost(null);
        config.setJabberPort(5222);
        config.setJabberUsername(null);
        config.setJabberPassword(null);
        config.setJabberForceSSL(Boolean.FALSE);
    }

    private void saveConfig() {
        MasterConfiguration config = this.configurationManager.getAppConfig();
        config.setJabberHost(this.jabber.getHost());
        config.setJabberPort(this.jabber.getPort());
        config.setJabberUsername(this.jabber.getUsername());
        config.setJabberPassword(this.jabber.getPassword());
        config.setJabberForceSSL(this.jabber.getForceSSL());
    }

    private void loadConfig() {
        MasterConfiguration config = this.configurationManager.getAppConfig();
        this.jabber.setHost(config.getJabberHost());
        this.jabber.setPort(config.getJabberPort());
        this.jabber.setUsername(config.getJabberUsername());
        this.jabber.setPassword(config.getJabberPassword());
        this.jabber.setForceSSL(config.getJabberForceSSL());
    }

    public void setConfigurationManager(MasterConfigurationManager config) {
        this.configurationManager = config;
    }

    public void setJabberManager(JabberManager jabberManager) {
        this.jabberManager = jabberManager;
    }

    public class JabberConfig {
        private String host;
        private int port = 5222;
        private String username;
        private String password;
        private Boolean forceSSL;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public Boolean getForceSSL() {
            return this.forceSSL;
        }

        public void setForceSSL(Boolean forceSSL) {
            this.forceSSL = forceSSL;
        }
    }
}

