/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.util.Sort;
import com.zutubi.pulse.web.admin.ResourceActionSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditResourceAction
extends ResourceActionSupport {
    private String newName;
    private String defaultVersion;

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public List<String> getVersions() {
        Set versions = this.resource.getVersions().keySet();
        ArrayList<String> result = new ArrayList<String>(versions.size() + 1);
        result.add("");
        result.addAll(versions);
        Collections.sort(result, new Sort.StringComparator());
        return result;
    }

    public String doInput() {
        this.lookupResource();
        if (this.hasErrors()) {
            return "error";
        }
        this.newName = this.resource.getName();
        this.defaultVersion = this.resource.getDefaultVersion();
        return "input";
    }

    public void validate() {
        this.lookupResource();
        if (this.hasErrors()) {
            return;
        }
        if (!TextUtils.stringSet((String)this.newName)) {
            this.addFieldError("newName", "name is required");
            return;
        }
        if (!this.resource.getName().equals(this.newName) && this.getResourceManager().findBySlaveAndName(this.resource.getSlave(), this.newName) != null) {
            this.addFieldError("newName", "this agent already has a resource with name '" + this.newName + "'");
        }
    }

    public String execute() {
        this.getResourceManager().editResource(this.resource, this.newName, this.defaultVersion);
        return "success";
    }
}

