/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web;

import com.zutubi.pulse.filesystem.File;

public class DirectoryEntry {
    private String path;
    private boolean isDirectory;
    private String name;
    private String mimeType;
    private long size;

    public DirectoryEntry(File file, String name) {
        this.path = file.getPath();
        this.isDirectory = file.isDirectory();
        this.mimeType = this.isDirectory ? "directory" : file.getMimeType();
        this.name = name;
        this.size = file.length();
    }

    public String getPath() {
        return this.path;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public long getSize() {
        return this.size;
    }

    public String getPrettySize() {
        String units;
        double s;
        if (this.size > 0x100000L) {
            s = (double)this.size / 1048576.0;
            units = "MB";
        } else if (this.size > 1024L) {
            s = (double)this.size / 1024.0;
            units = "kB";
        } else {
            return this.size + " bytes";
        }
        return String.format("%.02f %s", s, units);
    }
}

