/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.LocaleProvider;
import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.zutubi.pulse.committransformers.CommitMessageTransformerManager;
import com.zutubi.pulse.core.model.Changelist;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.security.AcegiUtils;
import com.zutubi.pulse.util.StringUtils;
import com.zutubi.pulse.util.TimeStamps;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.web.project.CommitMessageSupport;
import com.zutubi.pulse.xwork.TextProviderSupport;
import com.zutubi.pulse.xwork.interceptor.Cancelable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class ActionSupport
extends com.opensymphony.xwork.ActionSupport
implements Cancelable {
    private static final Logger LOG = Logger.getLogger(ActionSupport.class);
    protected static final String ERROR_REQUEST_URI = "javax.servlet.error.request_uri";
    protected static final String ERROR_MESSAGE = "javax.servlet.error.message";
    protected static final String ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    protected static final String ERROR_EXCEPTION = "javax.servlet.error.exception";
    private final transient TextProvider textProvider = new TextProviderSupport(this.getClass(), (LocaleProvider)this);
    private String cancel;
    protected ProjectManager projectManager;
    protected String changeUrl;
    protected CommitMessageTransformerManager commitMessageTransformerManager;

    public boolean isCancelled() {
        return this.cancel != null;
    }

    public void setCancel(String name) {
        this.cancel = name;
    }

    public Object getPrinciple() {
        return AcegiUtils.getLoggedInUser();
    }

    public String trimmedString(String s, int length) {
        return StringUtils.trimmedString((String)s, (int)length);
    }

    public String getText(String aTextName) {
        return this.textProvider.getText(aTextName);
    }

    public String getText(String aTextName, List args) {
        return this.textProvider.getText(aTextName, args);
    }

    public String getText(String aTextName, String defaultValue) {
        return this.textProvider.getText(aTextName, defaultValue);
    }

    public String getText(String aTextName, String defaultValue, List args) {
        return this.textProvider.getText(aTextName, defaultValue, args);
    }

    public String getText(String key, String defaultValue, List args, OgnlValueStack stack) {
        return this.textProvider.getText(key, defaultValue, args, stack);
    }

    public ResourceBundle getTexts() {
        return this.textProvider.getTexts();
    }

    public ResourceBundle getTexts(String aBundleName) {
        return this.textProvider.getTexts(aBundleName);
    }

    public boolean notNull(Object object) {
        return object != null;
    }

    public Locale getLocale() {
        return ActionContext.getContext().getLocale();
    }

    public String getPrettyTime(long time) {
        return TimeStamps.getPrettyTime((long)time);
    }

    public String getPrettyDate(long time) {
        return TimeStamps.getPrettyDate((long)time, (Locale)this.getLocale());
    }

    public String wrapString(String s, int lineLength) {
        return StringUtils.wrapString((String)s, (int)lineLength, null);
    }

    public String plainToHtml(String s) {
        return TextUtils.plainTextToHtml((String)s);
    }

    public String escapeSpaces(String s) {
        return s.replace(" ", "%20");
    }

    public String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public String jsStringEncode(String s) {
        return TextUtils.htmlEncode((String)s).replace("'", "\\'");
    }

    public String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public boolean canWrite(Project project) {
        try {
            this.getProjectManager().checkWrite(project);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public ProjectManager getProjectManager() {
        return this.projectManager;
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public void updateChangeUrl(Project project, Revision revision) {
        try {
            if (revision != null && project != null && project.getChangeViewer() != null) {
                this.changeUrl = project.getChangeViewer().getChangesetURL(revision);
                return;
            }
        }
        catch (Exception e) {
            LOG.severe((Throwable)e);
        }
        this.changeUrl = null;
    }

    public String getChangeUrl() {
        return this.changeUrl;
    }

    public void updateChangeUrl(Changelist changelist) {
        try {
            Revision revision;
            if (changelist != null && (revision = changelist.getRevision()) != null) {
                Iterator i$ = changelist.getProjectIds().iterator();
                while (i$.hasNext()) {
                    String url;
                    long id = (Long)i$.next();
                    Project p = this.getProjectManager().getProject(id);
                    if (p == null || p.getChangeViewer() == null || (url = p.getChangeViewer().getChangesetURL(revision)) == null) continue;
                    this.changeUrl = url;
                    return;
                }
            }
        }
        catch (Exception e) {
            LOG.severe((Throwable)e);
        }
        this.changeUrl = null;
    }

    public void setCommitMessageTransformerManager(CommitMessageTransformerManager commitMessageTransformerManager) {
        this.commitMessageTransformerManager = commitMessageTransformerManager;
    }

    public CommitMessageSupport getCommitMessageSupport(Changelist changelist) {
        return new CommitMessageSupport(changelist, this.commitMessageTransformerManager.getCommitMessageTransformers());
    }
}

