/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.AddressableFileObject;
import com.zutubi.pulse.vfs.pulse.BuildResultProvider;
import com.zutubi.pulse.vfs.pulse.WorkingCopyStageFileObject;
import java.util.LinkedList;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class WorkingCopyContextFileObject
extends AbstractPulseFileObject
implements AddressableFileObject {
    public WorkingCopyContextFileObject(FileName name, AbstractFileSystem fs) {
        super(name, fs);
    }

    public AbstractPulseFileObject createFile(FileName fileName) throws Exception {
        long recipeId = Long.parseLong(fileName.getBaseName());
        return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(WorkingCopyStageFileObject.class, new Class[]{FileName.class, Long.TYPE, AbstractFileSystem.class}, new Object[]{fileName, recipeId, this.pfs}));
    }

    protected FileType doGetType() throws Exception {
        return FileType.FOLDER;
    }

    protected String[] doListChildren() throws Exception {
        LinkedList<String> recipeIds = new LinkedList<String>();
        BuildResult result = this.getBuildResult();
        for (RecipeResultNode node : result.getRoot().getChildren()) {
            recipeIds.add(Long.toString(node.getResult().getId()));
        }
        return recipeIds.toArray(new String[recipeIds.size()]);
    }

    private BuildResult getBuildResult() throws FileSystemException {
        BuildResultProvider provider = (BuildResultProvider)((Object)this.getAncestor(BuildResultProvider.class));
        return provider.getBuildResult();
    }

    private long getBuildResultId() {
        try {
            BuildResultProvider provider = (BuildResultProvider)((Object)this.getAncestor(BuildResultProvider.class));
            return provider.getBuildResultId();
        }
        catch (FileSystemException e) {
            return -1L;
        }
    }

    public boolean isLocal() {
        return true;
    }

    public String getUrlPath() {
        return "/browseProjectDir.action?buildId=" + this.getBuildResultId();
    }
}

