/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.vfs.pulse.PulseFileNameParser;
import com.zutubi.pulse.vfs.pulse.PulseFileSystem;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs.provider.FileNameParser;

public class PulseFileProvider
extends AbstractOriginatingFileProvider {
    private ObjectFactory objectFactory;
    static final Collection CAPABILITIES = Collections.unmodifiableCollection(Arrays.asList(Capability.GET_TYPE, Capability.READ_CONTENT, Capability.URI, Capability.GET_LAST_MODIFIED));

    public PulseFileProvider() {
        this.setFileNameParser((FileNameParser)PulseFileNameParser.getInstance());
    }

    protected FileSystem doCreateFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        try {
            return (FileSystem)this.objectFactory.buildBean(PulseFileSystem.class, new Class[]{FileName.class, FileObject.class, FileSystemOptions.class}, new Object[]{rootName, null, fileSystemOptions});
        }
        catch (Exception e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public Collection getCapabilities() {
        return CAPABILITIES;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }
}

