/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.vfs.pulse.PulseFileName;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileNameParser;
import org.apache.commons.vfs.provider.FileNameParser;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.VfsComponentContext;

public class PulseFileNameParser
extends AbstractFileNameParser {
    private static final PulseFileNameParser INSTANCE = new PulseFileNameParser();

    public static PulseFileNameParser getInstance() {
        return INSTANCE;
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
        StringBuffer name = new StringBuffer();
        name.append(filename);
        String scheme = UriParser.extractScheme((String)filename, (StringBuffer)name);
        if (name.length() < 2 || name.charAt(0) != '/' || name.charAt(1) != '/') {
            throw new FileSystemException("vfs.provider/missing-double-slashes.error", (Object)filename);
        }
        name.delete(0, 2);
        UriParser.canonicalizePath((StringBuffer)name, (int)0, (int)name.length(), (FileNameParser)this);
        UriParser.fixSeparators((StringBuffer)name);
        FileType fileType = UriParser.normalisePath((StringBuffer)name);
        String path = name.toString();
        return new PulseFileName(scheme, path, fileType);
    }
}

