/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.AddressableFileObject;
import com.zutubi.pulse.vfs.pulse.ProjectFileObject;
import com.zutubi.pulse.vfs.pulse.PulseFileName;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class ProjectsFileObject
extends AbstractPulseFileObject
implements AddressableFileObject {
    public ProjectsFileObject(FileName name, AbstractFileSystem fs) {
        super(name, fs);
    }

    public AbstractPulseFileObject createFile(FileName fileName) throws Exception {
        long projectId = this.convertToProjectId(fileName.getBaseName());
        if (projectId != -1L) {
            String absPath = fileName.getParent().getPath() + "/" + projectId;
            fileName = new PulseFileName(fileName.getScheme(), absPath, fileName.getType());
            return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(ProjectFileObject.class, new Class[]{FileName.class, Long.TYPE, AbstractFileSystem.class}, new Object[]{fileName, projectId, this.pfs}));
        }
        return null;
    }

    private long convertToProjectId(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            Project project = this.projectManager.getProject(str);
            if (project != null) {
                return project.getId();
            }
            return -1L;
        }
    }

    protected FileType doGetType() throws Exception {
        return FileType.FOLDER;
    }

    protected String[] doListChildren() throws Exception {
        return new String[0];
    }

    public boolean isLocal() {
        return true;
    }

    public String getUrlPath() {
        return "/viewProjects.action";
    }
}

