/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.core.model.RecipeResult;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.BuildResultProvider;
import com.zutubi.pulse.vfs.pulse.NamedCommandFileObject;
import com.zutubi.pulse.vfs.pulse.RecipeResultProvider;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class NamedStageFileObject
extends AbstractPulseFileObject
implements RecipeResultProvider {
    private final String recipeName;

    public NamedStageFileObject(FileName name, String recipeName, AbstractFileSystem fs) {
        super(name, fs);
        this.recipeName = recipeName;
    }

    public AbstractPulseFileObject createFile(FileName fileName) throws Exception {
        String name = fileName.getBaseName();
        return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(NamedCommandFileObject.class, new Class[]{FileName.class, String.class, AbstractFileSystem.class}, new Object[]{fileName, name, this.pfs}));
    }

    protected FileType doGetType() throws Exception {
        return FileType.FOLDER;
    }

    protected String[] doListChildren() throws Exception {
        return new String[0];
    }

    public RecipeResult getRecipeResult() throws FileSystemException {
        BuildResult result = this.getBuildResult();
        if (result == null) {
            throw new FileSystemException("No build result available.");
        }
        RecipeResultNode node = result.getRoot().findNode(this.recipeName);
        if (node == null) {
            throw new FileSystemException(String.format("No recipe by the name '%s' is available.", this.recipeName));
        }
        RecipeResult recipeResult = node.getResult();
        if (recipeResult == null) {
            throw new FileSystemException("No recipe result is available.");
        }
        return recipeResult;
    }

    public long getRecipeResultId() throws FileSystemException {
        return this.getRecipeResult().getId();
    }

    protected BuildResult getBuildResult() throws FileSystemException {
        BuildResultProvider provider = (BuildResultProvider)((Object)this.getAncestor(BuildResultProvider.class));
        if (provider == null) {
            throw new FileSystemException("Missing build result context.");
        }
        return provider.getBuildResult();
    }
}

