/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.AddressableFileObject;
import com.zutubi.pulse.vfs.pulse.ArtifactProvider;
import com.zutubi.pulse.vfs.pulse.CommandResultProvider;
import java.io.File;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class NamedFileArtifactFileObject
extends AbstractPulseFileObject
implements AddressableFileObject {
    private File file;

    public NamedFileArtifactFileObject(FileName name, File file, AbstractFileSystem fs) {
        super(name, fs);
        this.file = file;
    }

    public AbstractPulseFileObject createFile(FileName fileName) throws Exception {
        String name = fileName.getBaseName();
        File newFile = new File(this.file, name);
        return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(NamedFileArtifactFileObject.class, new Class[]{FileName.class, File.class, AbstractFileSystem.class}, new Object[]{fileName, newFile, this.pfs}));
    }

    protected FileType doGetType() throws Exception {
        if (this.file.isDirectory()) {
            return FileType.FOLDER;
        }
        if (this.file.isFile()) {
            return FileType.FILE;
        }
        return FileType.IMAGINARY;
    }

    protected String[] doListChildren() throws Exception {
        return new String[0];
    }

    public boolean isLocal() {
        return true;
    }

    public String getUrlPath() throws FileSystemException {
        if (this.file.isDirectory()) {
            throw new FileSystemException("Displaying of artifact directories is not supported.");
        }
        String basePath = this.getArtifactBase().getAbsolutePath();
        String artifactPath = this.file.getAbsolutePath();
        String path = artifactPath.substring(basePath.length() + 1);
        path = path.replace('\\', '/');
        return "/file/artifacts/" + this.getArtifact().getId() + "/" + path;
    }

    private File getArtifactBase() throws FileSystemException {
        CommandResult result = this.getCommandResult();
        StoredArtifact artifact = this.getArtifact();
        File outputDir = result.getAbsoluteOutputDir(this.pfs.getConfigurationManager().getDataDirectory());
        return new File(outputDir, artifact.getName());
    }

    protected StoredArtifact getArtifact() throws FileSystemException {
        ArtifactProvider provider = (ArtifactProvider)((Object)this.getAncestor(ArtifactProvider.class));
        return provider.getArtifact();
    }

    protected CommandResult getCommandResult() throws FileSystemException {
        CommandResultProvider provider = (CommandResultProvider)((Object)this.getAncestor(CommandResultProvider.class));
        return provider.getCommandResult();
    }
}

