/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.ArtifactFileObject;
import com.zutubi.pulse.vfs.pulse.CommandResultProvider;
import java.util.LinkedList;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class CommandResultFileObject
extends AbstractPulseFileObject
implements CommandResultProvider {
    private final long commandResultId;
    private String displayName;

    public CommandResultFileObject(FileName name, long commandResultId, AbstractFileSystem fs) {
        super(name, fs);
        this.commandResultId = commandResultId;
    }

    public AbstractPulseFileObject createFile(FileName fileName) throws Exception {
        long artifactId = Long.parseLong(fileName.getBaseName());
        return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(ArtifactFileObject.class, new Class[]{FileName.class, Long.TYPE, AbstractFileSystem.class}, new Object[]{fileName, artifactId, this.pfs}));
    }

    protected FileType doGetType() throws Exception {
        return FileType.FOLDER;
    }

    protected String[] doListChildren() throws Exception {
        LinkedList<String> children = new LinkedList<String>();
        for (StoredArtifact artifact : this.getCommandResult().getArtifacts()) {
            children.add(Long.toString(artifact.getId()));
        }
        return children.toArray(new String[children.size()]);
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            CommandResult commandResult = this.getCommandResult();
            this.displayName = String.format("command :: %s", commandResult.getCommandName());
        }
        return this.displayName;
    }

    public CommandResult getCommandResult() {
        return this.buildManager.getCommandResult(this.getCommandResultId());
    }

    public long getCommandResultId() {
        return this.commandResultId;
    }
}

