/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.BuildFileObject;
import com.zutubi.pulse.vfs.pulse.ProjectProvider;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class BuildsFileObject
extends AbstractPulseFileObject {
    public BuildsFileObject(FileName name, AbstractFileSystem fs) {
        super(name, fs);
    }

    public AbstractPulseFileObject createFile(FileName fileName) throws Exception {
        long buildId = this.convertToBuildId(fileName.getBaseName());
        if (buildId != -1L) {
            return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(BuildFileObject.class, new Class[]{FileName.class, Long.TYPE, AbstractFileSystem.class}, new Object[]{fileName, buildId, this.pfs}));
        }
        return null;
    }

    private long convertToBuildId(String str) throws FileSystemException {
        Project project;
        BuildResult result;
        long id = Long.parseLong(str);
        ProjectProvider provider = (ProjectProvider)((Object)this.getAncestor(ProjectProvider.class));
        if (provider != null && (result = this.buildManager.getByProjectAndNumber(project = provider.getProject(), id)) != null) {
            return result.getId();
        }
        BuildResult result2 = this.buildManager.getBuildResult(id);
        if (result2 != null) {
            return id;
        }
        return -1L;
    }

    protected FileType doGetType() throws Exception {
        return FileType.FOLDER;
    }

    protected String[] doListChildren() throws Exception {
        return new String[0];
    }
}

