/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.BuildSpecificationProvider;
import com.zutubi.pulse.vfs.pulse.LatestBuildFileObject;
import com.zutubi.pulse.vfs.pulse.LatestSuccessfulBuildFileObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class BuildSpecificationFileObject
extends AbstractPulseFileObject
implements BuildSpecificationProvider {
    private static final Map<String, Class> nodesDefinitions = new HashMap<String, Class>();
    private long buildSpecificationId;

    public BuildSpecificationFileObject(FileName name, long buildSpecificationId, AbstractFileSystem fs) {
        super(name, fs);
        nodesDefinitions.put("latest", LatestBuildFileObject.class);
        nodesDefinitions.put("latestsuccessful", LatestSuccessfulBuildFileObject.class);
        nodesDefinitions.put("successful", LatestSuccessfulBuildFileObject.class);
        this.buildSpecificationId = buildSpecificationId;
    }

    public AbstractPulseFileObject createFile(FileName fileName) throws Exception {
        String name = fileName.getBaseName();
        if (nodesDefinitions.containsKey(name)) {
            Class clazz = nodesDefinitions.get(name);
            return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(clazz, new Class[]{FileName.class, AbstractFileSystem.class}, new Object[]{fileName, this.pfs}));
        }
        return null;
    }

    protected FileType doGetType() throws Exception {
        return FileType.FOLDER;
    }

    protected String[] doListChildren() throws Exception {
        Set<String> rootPaths = nodesDefinitions.keySet();
        return rootPaths.toArray(new String[rootPaths.size()]);
    }

    public BuildSpecification getBuildSpecification() {
        return this.projectManager.getBuildSpecification(this.getBuildSpecificationId());
    }

    public long getBuildSpecificationId() {
        return this.buildSpecificationId;
    }
}

