/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.AddressableFileObject;
import com.zutubi.pulse.vfs.pulse.ArtifactsContextFileObject;
import com.zutubi.pulse.vfs.pulse.BuildResultProvider;
import com.zutubi.pulse.vfs.pulse.ProjectProvider;
import com.zutubi.pulse.vfs.pulse.WorkingCopyContextFileObject;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class BuildFileObject
extends AbstractPulseFileObject
implements BuildResultProvider,
AddressableFileObject,
ProjectProvider {
    private final long buildId;

    public BuildFileObject(FileName name, long buildId, AbstractFileSystem fs) {
        super(name, fs);
        this.buildId = buildId;
    }

    public AbstractPulseFileObject createFile(FileName fileName) throws Exception {
        String name = fileName.getBaseName();
        if (name.equals("wc")) {
            return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(WorkingCopyContextFileObject.class, new Class[]{FileName.class, AbstractFileSystem.class}, new Object[]{fileName, this.pfs}));
        }
        if (name.equals("artifacts")) {
            return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(ArtifactsContextFileObject.class, new Class[]{FileName.class, AbstractFileSystem.class}, new Object[]{fileName, this.pfs}));
        }
        return null;
    }

    protected FileType doGetType() throws Exception {
        return FileType.FOLDER;
    }

    protected String[] doListChildren() throws Exception {
        return new String[]{"wc", "artifacts"};
    }

    public boolean isLocal() {
        return true;
    }

    public String getUrlPath() {
        return "/viewBuild.action?id=" + this.buildId;
    }

    public BuildResult getBuildResult() {
        return this.buildManager.getBuildResult(this.getBuildResultId());
    }

    public long getBuildResultId() {
        return this.buildId;
    }

    public Project getProject() {
        return this.getBuildResult().getProject();
    }

    public long getProjectId() {
        return this.getProject().getId();
    }
}

